% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_optimize_histogram_bins.R
\name{util_optimize_histogram_bins}
\alias{util_optimize_histogram_bins}
\title{Utility function to compute and optimize bin breaks for histograms}
\usage{
util_optimize_histogram_bins(
  x,
  iqr_bw,
  n_bw,
  min_within = NULL,
  max_within = NULL,
  min_plot = NULL,
  max_plot = NULL,
  nbins_max = NULL
)
}
\arguments{
\item{x}{a vector of data values (numeric or datetime)}

\item{iqr_bw}{the interquartile range of values which should be included to
calculate the Freedman-Diaconis bandwidth (e.g., for
\code{con_limit_deviations} only values within limits)}

\item{n_bw}{the number of values which should be included to calculate the
Freedman-Diaconis bandwidth (e.g., for \code{con_limit_deviations}
the number of values within limits)}

\item{min_within}{the minimum value which is still within limits
(needed for \code{con_limit_deviations})}

\item{max_within}{the maximum value which is still within limits
(needed for \code{con_limit_deviations})}

\item{min_plot}{the minimum value which should be included in the plot}

\item{max_plot}{the maximum value which should be included in the plot}

\item{nbins_max}{the maximum number of bins for the histogram. Strong
outliers can cause too many narrow bins, which might be
even to narrow to be plotted. This also results in large
files and rendering problems. So it is sensible to limit
the number of bins. The function will produce a warning if
it reduces the number of bins in such a case. Reasons
could be unspecified missing value codes, or minimum or
maximum values far away from most of the data values, or
(for \code{con_limit_deviations}) no or few values within limits.}
}
\value{
a list with bin breaks below, within and above limits
}
\description{
Utility function to compute and optimize bin breaks for histograms
}
