% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{replaceMember}
\alias{replaceMember}
\alias{replaceMember,DataPackage-method}
\title{Replace the raw data or file associated with a DataObject}
\usage{
replaceMember(x, do, ...)

\S4method{replaceMember}{DataPackage}(x, do, replacement,
  formatId = NA_character_, mediaType = NA_character_,
  mediaTypeProperty = NA_character_, newId = NA_character_, ...)
}
\arguments{
\item{x}{A DataPackage instance}

\item{do}{A DataObject instance}

\item{...}{(Not yet used)}

\item{replacement}{A \code{raw} object or \code{character} (for filename) that will replace the current value in the DataObject \code{do}.}

\item{formatId}{A value of type \code{"character"}, the DataONE object format for the object.}

\item{mediaType}{A value of type \code{"character"}, the IANA Media Type (aka MIME-Type) of the object, e.g. "text/csv".}

\item{mediaTypeProperty}{A value of type \code{"list"} of \code{"character"}, IANA Media Type properties for the \code{"mediaType"} argument.}

\item{newId}{A value of type \code{"character"} which will replace the identifier for this DataObject.}
}
\description{
A DataObject is a container for data that can be either an R raw object or
a file on local disk. The \code{replaceMember} method can be used to update the
date that a DataObject contains, for a DataObject that is a member of a DataPackage, 
substituting a new file or raw object in the specified DataObject.
}
\details{
The data that is replacing the existing DataObject data may be of a different
format or type than the existing data. Because the data type and format may change, the
system metadata that describes the data can be updated as well. The \code{replaceMember}
method will update the SystemMetadata \code{size}, \code{checksum} values automatically, 
but does not update the \code{formatId}, \code{mediaType}, \code{mediaTypeProperty}
unless requested, so these should be specified in the call to \code{replaceMember} if necessary. 
If the \code{newId} argument is used, the specified new identifier will be assigned to the 
object, otherwise one will be generated if necessary. This new identifier will be used
if the DataPackage is uploaded to DataONE, and this object is updating an existing object in DataONE.
}
\examples{
# Create a DataObject and add it to the DataPackage
dp <- new("DataPackage")
doIn <- new("DataObject", format="text/csv", 
            filename=system.file("./extdata/pkg-example/binary.csv", package="datapack"))
dp <- addMember(dp, doIn)

# Use the zipped version of the file instead by updating the DataObject
dp <- replaceMember(dp, doIn, 
          replacement=system.file("./extdata/pkg-example/binary.csv.zip", 
          package="datapack"),
                    formatId="application/zip")
}
\seealso{
\code{\link{DataPackage-class}}
}
