% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceMap.R
\docType{methods}
\name{parseRDF}
\alias{parseRDF}
\alias{parseRDF,ResourceMap-method}
\title{Parse an RDF/XML resource map from a file.}
\usage{
parseRDF(x, rdf, ...)

\S4method{parseRDF}{ResourceMap}(x, rdf, asText = FALSE, name = "rdfxml",
  mimeType = "application/rdf+xml", ...)
}
\arguments{
\item{x}{ResourceMap}

\item{rdf}{A file or character value containing a resource map that will be parsed into the ResourceMap object}

\item{...}{Additional parameters (not yet used).}

\item{asText}{A logical value. If TRUE, then the 'rdf' parameter is a character vector, if FALSE then it is the name of a file to read.}

\item{name}{The name of the RDF xml parser, the default is "rdfxml".}

\item{mimeType}{A character value containing the RDF format type. The default is "application/rdf+xml".}
}
\value{
x the ResourceMap containing the parsed RDF/XML content
}
\description{
parseRDF reads a file containing an RDF model in RDF/XML format and initializes
a ResourceMap based on this content.
}
\details{
This method resets the slot ResourceMap@world so any previously stored triples are discarded, allowing
for a clean model object in which to parse the new RDF content into. It is assumed that the content is a
valid ORE resource map therefor no validation checks specific to the OAI-ORE content model are performed.
}
