/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpSlice
extends OpModifier {
    private long start;
    private long length;

    public OpSlice(Op subOp, long start, long length) {
        super(subOp);
        this.start = start;
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public long getStart() {
        return this.start;
    }

    public Op copy() {
        return null;
    }

    public String getName() {
        return "slice";
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        return new OpSlice(subOp, this.start, this.length);
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public int hashCode() {
        return this.getSubOp().hashCode() ^ (int)(this.start & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.length & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpSlice)) {
            return false;
        }
        OpSlice opSlice = (OpSlice)other;
        if (opSlice.start != this.start || opSlice.length != this.length) {
            return false;
        }
        return this.getSubOp().equalTo(opSlice.getSubOp(), labelMap);
    }
}

