/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.auth;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.dataone.client.CNode;
import org.dataone.client.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.util.TypeMarshaller;
import org.jibx.runtime.JiBXException;

public class CertificateManager {
    private static Log log = LogFactory.getLog(CertificateManager.class);
    private String certificateLocation = null;
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private static final String shippedCAcerts = "/org/dataone/client/auth/d1-trusted-certs.crt";
    private KeyStore d1TrustStore;
    private static String CILOGON_OID_SUBJECT_INFO;
    private static CertificateManager cm;
    private Map<String, X509Certificate> certificates;
    private Map<String, PrivateKey> keys;
    private boolean trustStoreIncludesD1CAs = true;

    public CertificateManager() {
        try {
            this.keyStorePassword = Settings.getConfiguration().getString("certificate.keystore.password");
            this.keyStoreType = Settings.getConfiguration().getString("certificate.keystore.type", KeyStore.getDefaultType());
            this.trustStoreIncludesD1CAs = Settings.getConfiguration().getBoolean("certificate.truststore.includeD1CAs", true);
            this.certificates = new HashMap<String, X509Certificate>();
            this.keys = new HashMap<String, PrivateKey>();
            CILOGON_OID_SUBJECT_INFO = Settings.getConfiguration().getString("cilogon.oid.subjectinfo", "1.3.6.1.4.1.34998.2.1");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static CertificateManager getInstance() {
        if (cm == null) {
            cm = new CertificateManager();
        }
        return cm;
    }

    public String getCertificateLocation() {
        return this.certificateLocation;
    }

    public void setCertificateLocation(String certificate) {
        this.certificateLocation = certificate;
    }

    public void registerCertificate(String subject, X509Certificate certificate, PrivateKey key) {
        this.certificates.put(subject, certificate);
        this.keys.put(subject, key);
    }

    private KeyStore loadTrustStore() {
        if (this.d1TrustStore == null) {
            try {
                File loc;
                this.d1TrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.d1TrustStore.load(null, null);
                String auxLocation = Settings.getConfiguration().getString("certificate.truststore.aux.location");
                int count = 0;
                if (auxLocation != null && (loc = new File(auxLocation)).exists()) {
                    if (loc.isDirectory()) {
                        for (File f : loc.listFiles()) {
                            count += this.loadIntoTrustStore(this.d1TrustStore, new FileReader(f.getAbsolutePath()));
                        }
                    } else {
                        count += this.loadIntoTrustStore(this.d1TrustStore, new FileReader(loc.getAbsolutePath()));
                    }
                }
                if (count == 0) {
                    InputStream shippedCerts = this.getClass().getResourceAsStream(shippedCAcerts);
                    if (shippedCerts != null) {
                        count += this.loadIntoTrustStore(this.d1TrustStore, new InputStreamReader(shippedCerts));
                    } else {
                        log.error((Object)"'shippedCAcerts' file (/org/dataone/client/auth/d1-trusted-certs.crt) could not be found. No DataONE-trusted CA certs loaded");
                    }
                }
                Enumeration<String> aliases = this.d1TrustStore.aliases();
                while (aliases.hasMoreElements()) {
                    log.debug((Object)aliases.nextElement());
                }
                log.debug(this.d1TrustStore.aliases());
            }
            catch (KeyStoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CertificateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.d1TrustStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int loadIntoTrustStore(KeyStore trustStore, Reader certLoc) throws FileNotFoundException {
        int count = 0;
        PEMReader pemReader = null;
        try {
            Object pemObject;
            pemReader = new PEMReader(certLoc);
            log.info((Object)"loading into client truststore: ");
            while ((pemObject = pemReader.readObject()) != null) {
                X509Certificate certificate;
                String alias;
                if (!(pemObject instanceof X509Certificate) || trustStore.containsAlias(alias = (certificate = (X509Certificate)pemObject).getSubjectX500Principal().getName())) continue;
                log.info((Object)(count + " alias " + alias));
                trustStore.setCertificateEntry(alias, certificate);
                ++count;
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)(e.getMessage() + " after loading " + count + " certificates"), (Throwable)e);
            IOUtils.closeQuietly((Reader)pemReader);
        }
        catch (IOException e2) {
            log.error((Object)(e2.getMessage() + " after loading " + count + " certificates"), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(pemReader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)pemReader);
        }
        IOUtils.closeQuietly((Reader)pemReader);
        return count;
    }

    public X509Certificate getCACert(String caAlias) {
        X509Certificate caCert = null;
        KeyStore trustStore = this.loadTrustStore();
        try {
            caCert = (X509Certificate)trustStore.getCertificate(caAlias);
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return caCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X509Certificate> getSupplementalCACertificates() {
        ArrayList<X509Certificate> caCerts = null;
        InputStream caStream = null;
        try {
            KeyStore trustStore = this.loadTrustStore();
            Enumeration<String> aliases = trustStore.aliases();
            caCerts = new ArrayList<X509Certificate>();
            while (aliases.hasMoreElements()) {
                String caAlias = aliases.nextElement();
                X509Certificate caCert = (X509Certificate)trustStore.getCertificate(caAlias);
                caCerts.add(caCert);
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(caStream);
        }
        return caCerts;
    }

    public X509Certificate loadCertificate() {
        X509Certificate cert = null;
        try {
            KeyStore keyStore = this.getKeyStore(null);
            cert = (X509Certificate)keyStore.getCertificate("cilogon");
        }
        catch (FileNotFoundException fnf) {
            log.warn((Object)fnf.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return cert;
    }

    public PrivateKey loadKey() {
        PrivateKey key = null;
        try {
            KeyStore keyStore = this.getKeyStore(null);
            key = (PrivateKey)keyStore.getKey("cilogon", this.keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return key;
    }

    protected String getExtensionValue(X509Certificate X509Certificate2, String oid) throws IOException {
        DEROctetString derOctetString;
        DERObject derObject;
        String decoded = null;
        byte[] extensionValue = X509Certificate2.getExtensionValue(oid);
        if (extensionValue != null && (derObject = this.toDERObject(extensionValue)) instanceof DEROctetString && (derObject = this.toDERObject((derOctetString = (DEROctetString)derObject).getOctets())) instanceof DERUTF8String) {
            DERUTF8String s = DERUTF8String.getInstance((Object)derObject);
            decoded = s.getString();
        }
        return decoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DERObject toDERObject(byte[] data) throws IOException {
        DERObject dero = null;
        ASN1InputStream asnInputStream = null;
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            asnInputStream = new ASN1InputStream((InputStream)inStream);
            dero = asnInputStream.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(asnInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)asnInputStream);
        return dero;
    }

    public SubjectInfo getSubjectInfo(X509Certificate certificate) throws IOException, InstantiationException, IllegalAccessException, JiBXException {
        String subjectInfoValue = this.getExtensionValue(certificate, CILOGON_OID_SUBJECT_INFO);
        log.debug((Object)("Certificate subjectInfoValue: " + subjectInfoValue));
        SubjectInfo subjectInfo = null;
        if (subjectInfoValue != null) {
            subjectInfo = (SubjectInfo)TypeMarshaller.unmarshalTypeFromStream(SubjectInfo.class, (InputStream)new ByteArrayInputStream(subjectInfoValue.getBytes("UTF-8")));
        }
        return subjectInfo;
    }

    public String getSubjectDN(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        return certificate.getSubjectX500Principal().getName("RFC2253");
    }

    public String standardizeDN(String name) {
        log.debug((Object)("name: " + name));
        X500Principal principal = new X500Principal(name);
        String standardizedName = principal.getName("RFC2253");
        log.debug((Object)("standardizedName: " + standardizedName));
        return standardizedName;
    }

    public boolean equalsDN(String dn1, String dn2) {
        return CertificateManager.getInstance().standardizeDN(dn1).equals(CertificateManager.getInstance().standardizeDN(dn2));
    }

    public static boolean verify(X509Certificate cert, X509Certificate caCert) {
        return CertificateManager.verify(cert, caCert, true);
    }

    public static boolean verify(X509Certificate cert, X509Certificate caCert, boolean logExceptions) {
        boolean isValid;
        block10: {
            isValid = false;
            try {
                cert.checkValidity();
                cert.verify(caCert.getPublicKey());
                isValid = true;
            }
            catch (CertificateException e) {
                if (logExceptions) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (InvalidKeyException e) {
                if (logExceptions) {
                    log.error((Object)"Certificate verification failed, invalid key.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchAlgorithmException e) {
                if (logExceptions) {
                    log.error((Object)"Certificate verification failed, no such algorithm.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchProviderException e) {
                if (logExceptions) {
                    log.error((Object)"Certificate verification failed, no such provider.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SignatureException e) {
                if (!logExceptions) break block10;
                log.error((Object)"Certificate verification failed, signatures do not match.");
            }
        }
        return isValid;
    }

    public Session getSession(HttpServletRequest request) throws InvalidToken {
        return this.getSession(request, false);
    }

    public Session getSession(HttpServletRequest request, boolean lookupSubject) throws InvalidToken {
        Session session = null;
        X509Certificate x509Cert = this.getCertificate(request);
        if (x509Cert != null) {
            String subjectDN = this.getSubjectDN(x509Cert);
            Subject subject = new Subject();
            subject.setValue(subjectDN);
            session = new Session();
            session.setSubject(subject);
            SubjectInfo subjectInfo = null;
            if (lookupSubject) {
                try {
                    CNode cn = D1Client.getCN();
                    subjectInfo = cn.getSubjectInfo(session, subject);
                    session.setSubjectInfo(subjectInfo);
                }
                catch (Exception e) {
                    log.error((Object)("Could not lookup complete SubjectInfo for: " + subject.getValue()), (Throwable)e);
                }
            } else {
                try {
                    subjectInfo = this.getSubjectInfo(x509Cert);
                }
                catch (Exception e) {
                    String msg = "Could not get SubjectInfo from certificate for: " + subject.getValue();
                    log.error((Object)msg, (Throwable)e);
                    throw new InvalidToken("", msg);
                }
            }
            session.setSubjectInfo(subjectInfo);
        }
        return session;
    }

    public X509Certificate getCertificate(HttpServletRequest request) {
        X509Certificate[] x509Certificates;
        X509Certificate[] arr$;
        int len$;
        int i$;
        Object certificate = request.getAttribute("javax.servlet.request.X509Certificate");
        log.debug((Object)("javax.servlet.request.X509Certificate  = " + certificate));
        Object sslSession = request.getAttribute("javax.servlet.request.ssl_session");
        log.debug((Object)("javax.servlet.request.ssl_session  = " + sslSession));
        if (certificate instanceof X509Certificate[] && (i$ = 0) < (len$ = (arr$ = (x509Certificates = (X509Certificate[])certificate)).length)) {
            X509Certificate x509Cert = arr$[i$];
            this.displayCertificate(x509Cert);
            return x509Cert;
        }
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory(String subjectString) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, CertificateException, IOException {
        log.info((Object)"Entering getSSLSocketFactory");
        SSLSocketFactory socketFactory = null;
        KeyStore keyStore = null;
        try {
            keyStore = this.getKeyStore(subjectString);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Client certificate could not be located. Setting up SocketFactory without it." + e.getMessage()));
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = this.getTrustManager();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keyStorePassword.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        ctx.init(keyManagers, new TrustManager[]{tm}, new SecureRandom());
        if (this.trustStoreIncludesD1CAs) {
            log.info((Object)"using allow-all hostname verifier");
            socketFactory = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        } else {
            socketFactory = new SSLSocketFactory(ctx);
        }
        return socketFactory;
    }

    private X509TrustManager getTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        X509TrustManager tm = null;
        X509TrustManager jvmTrustManager = null;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        log.debug((Object)"JVM Default Trust Managers:");
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            log.debug((Object)trustManager);
            if (!(trustManager instanceof X509TrustManager)) continue;
            jvmTrustManager = (X509TrustManager)trustManager;
            log.debug((Object)("Accepted issuers count : " + jvmTrustManager.getAcceptedIssuers().length));
            break;
        }
        if (this.trustStoreIncludesD1CAs) {
            log.info((Object)"creating custom TrustManager");
            final X509TrustManager defaultTrustManager = jvmTrustManager;
            tm = new X509TrustManager(){
                private List<X509Certificate> d1CaCertificates;
                {
                    this.d1CaCertificates = CertificateManager.this.getSupplementalCACertificates();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    System.err.println("checkClientTrusted - " + authType);
                    boolean trusted = false;
                    List<X509Certificate> combinedIssuers = Arrays.asList(this.getAcceptedIssuers());
                    for (X509Certificate cert : chain) {
                        if (!combinedIssuers.contains(cert)) continue;
                        trusted = true;
                        break;
                    }
                    if (!trusted) {
                        defaultTrustManager.checkClientTrusted(chain, authType);
                    }
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    System.err.println("checkServerTrusted - " + authType);
                    boolean trusted = false;
                    List<X509Certificate> combinedIssuers = Arrays.asList(this.getAcceptedIssuers());
                    block2: for (X509Certificate cert : chain) {
                        for (X509Certificate caCert : combinedIssuers) {
                            if (!CertificateManager.verify(cert, caCert, false)) continue;
                            trusted = true;
                            continue block2;
                        }
                    }
                    if (!trusted) {
                        try {
                            System.err.println("CertMan Custom TrustManager: checking JVM trusted certs");
                            defaultTrustManager.checkServerTrusted(chain, authType);
                        }
                        catch (CertificateException ce) {
                            System.err.println("CertMan Custom TrustManager: server cert chain subjectDNs: ");
                            for (X509Certificate cert : chain) {
                                System.err.println("CertMan Custom TrustManager:   subjDN: " + cert.getSubjectDN() + " / issuerDN: " + cert.getIssuerX500Principal());
                            }
                            throw ce;
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    ArrayList<X509Certificate> combinedIssuers = new ArrayList<X509Certificate>();
                    combinedIssuers.addAll(this.d1CaCertificates);
                    combinedIssuers.addAll(Arrays.asList(defaultTrustManager.getAcceptedIssuers()));
                    return combinedIssuers.toArray(new X509Certificate[0]);
                }
            };
        } else {
            log.info((Object)"using JVM TrustManager");
            tm = jvmTrustManager;
        }
        return tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getKeyStore(String subjectString) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        X509Certificate certificate = null;
        PrivateKey privateKey = null;
        if (subjectString != null) {
            certificate = this.certificates.get(subjectString);
            privateKey = this.keys.get(subjectString);
        } else {
            String certLoc = this.certificateLocation;
            File certFile = certLoc == null ? this.locateDefaultCertificate() : new File(certLoc);
            log.info((Object)("Using client certificate location: " + certLoc));
            PEMReader pemReader = null;
            try {
                pemReader = new PEMReader((Reader)new FileReader(certFile));
                Object pemObject = null;
                KeyPair keyPair = null;
                while ((pemObject = pemReader.readObject()) != null) {
                    if (pemObject instanceof PrivateKey) {
                        privateKey = (PrivateKey)pemObject;
                        continue;
                    }
                    if (pemObject instanceof KeyPair) {
                        keyPair = (KeyPair)pemObject;
                        privateKey = keyPair.getPrivate();
                        continue;
                    }
                    if (!(pemObject instanceof X509Certificate)) continue;
                    certificate = (X509Certificate)pemObject;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pemReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)pemReader);
        }
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        keyStore.load(null, this.keyStorePassword.toCharArray());
        Certificate[] chain = new Certificate[]{certificate};
        keyStore.setKeyEntry("cilogon", privateKey, this.keyStorePassword.toCharArray(), chain);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey loadPrivateKeyFromFile(String fileName, final String password) throws IOException {
        Object pemObject = null;
        PrivateKey privateKey = null;
        PEMReader pemReader = null;
        try {
            if (password != null && password.length() > 0) {
                PasswordFinder passwordFinder = new PasswordFinder(){

                    public char[] getPassword() {
                        return password.toCharArray();
                    }
                };
                pemReader = new PEMReader((Reader)new FileReader(fileName), passwordFinder);
            } else {
                pemReader = new PEMReader((Reader)new FileReader(fileName));
            }
            KeyPair keyPair = null;
            while ((pemObject = pemReader.readObject()) != null) {
                if (pemObject instanceof PrivateKey) {
                    privateKey = (PrivateKey)pemObject;
                }
                if (!(pemObject instanceof KeyPair)) continue;
                keyPair = (KeyPair)pemObject;
                privateKey = keyPair.getPrivate();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pemReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)pemReader);
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate loadCertificateFromFile(String fileName) throws IOException {
        X509Certificate certificate = null;
        PEMReader pemReader = null;
        try {
            pemReader = new PEMReader((Reader)new FileReader(fileName));
            Object pemObject = null;
            while ((pemObject = pemReader.readObject()) != null) {
                if (!(pemObject instanceof X509Certificate)) continue;
                certificate = (X509Certificate)pemObject;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pemReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)pemReader);
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File locateDefaultCertificate() throws FileNotFoundException {
        StringBuffer location = new StringBuffer();
        String tmp = System.getProperty("tmpdir");
        if (tmp == null) {
            tmp = "/tmp";
        }
        String uid = null;
        BufferedReader reader = null;
        try {
            Process process = Runtime.getRuntime().exec("id -u");
            int ret = process.waitFor();
            if (ret == 0) {
                InputStream stream = process.getInputStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                String result = reader.readLine();
                int testUid = Integer.parseInt(result);
                uid = String.valueOf(testUid);
            }
        }
        catch (Exception e) {
            log.warn((Object)"No UID found, using user.name");
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        if (uid == null) {
            uid = System.getProperty("user.name");
        }
        location.append(tmp);
        location.append("/");
        location.append("x509up_u");
        location.append(uid);
        log.debug((Object)("Calculated certificate location: " + location.toString()));
        File fileLocation = new File(location.toString());
        if (!fileLocation.exists()) {
            throw new FileNotFoundException("No certificate installed in expected location: " + location.toString());
        }
        return fileLocation;
    }

    public void displayCertificate(X509Certificate cert) {
        if (cert == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            log.debug((Object)(" Issuer: " + cert.getIssuerX500Principal().getName("RFC2253")));
            Date notBefore = cert.getNotBefore();
            DateFormat fmt = SimpleDateFormat.getDateTimeInstance();
            log.debug((Object)("   From: " + fmt.format(notBefore)));
            Date notAfter = cert.getNotAfter();
            log.debug((Object)("     To: " + fmt.format(notAfter)));
            log.debug((Object)("Subject: " + this.getSubjectDN(cert)));
            log.debug((Object)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CILOGON_OID_SUBJECT_INFO = null;
        cm = null;
    }
}

