% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\docType{methods}
\name{listObjects}
\alias{listObjects}
\alias{listObjects,D1Node-method}
\title{Retrieve the list of objects that match the search parameters}
\usage{
listObjects(x, ...)

\S4method{listObjects}{D1Node}(x, fromDate = as.character(NA),
  toDate = as.character(NA), formatId = as.character(NA),
  replicaStatus = as.logical(TRUE), start = as.integer(0),
  count = as.integer(1000))
}
\arguments{
\item{x}{The Node instance from which the SystemMetadata will be downloaded}

\item{...}{(Not yet used.)}

\item{fromDate}{Entries with a modified date greater than \code{'fromDate'} will be returned.
This value must be specified in ISO 8601 format, i.e. "YYYY-MM-DDTHH:MM:SS.mmm+00:00"}

\item{toDate}{Entries with a modified date less than \code{'toDate'} will be returned.
This value must be specified in ISO 8601 format, i.e. "YYYY-MM-DDTHH:MM:SS.mmm+00:00"}

\item{formatId}{The format to match, for example "eml://ecoinformatics.org/eml-2.1.1"}

\item{replicaStatus}{A logical value that determines if replica (object not on it's origin node) should be returned. Default is TRUE.}

\item{start}{An integer that specifies the first element of the result set that will be returned}

\item{count}{An integer that specifies how many results will be returned}
}
\value{
list Objects that met the search criteria

list Objects that met the search criteria
}
\description{
Retrieve the list of objects that match the search parameters
}
\details{
The list of objects that is returned is paged according to the \code{'start'} and
\code{'count'} values, so that large result sets can be returned over multiple calls.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode("STAGING")
fromDate <- "2013-01-01T01:01:01.000+00:00"
toDate <- "2015-12-31T01:01:01.000+00:00"
formatId <- "eml://ecoinformatics.org/eml-2.1.0"
start <- 0
count <- 5
objects <- listObjects(cn, fromDate=fromDate, toDate=toDate, 
    formatId=formatId, start=start, count=count)
# Inspect id of first object 
objects[1]$objectInfo$identifier
}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MN_read.listObjects}
}
