% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{baiTreelines2}
\alias{baiTreelines2}
\title{Incremento anual en área basal de cuatro especies arboreas.}
\format{
Contiene siete columnas, como las siguientes:
\describe{
  \item{clima}{Clase de clima de cada sitio: mediterraneano y templado.}
  \item{sitio}{Nombre del sitio de estudio (termas:Termas de Chillan , antillanca:Antillanca area within Puyehue National Park,
              castillo:Cerro Castillo Natural Reserve, farellones:Farellones in Central Chile, 
              pyrenees: Sierra de Cutas area in Spanish Central Pyrenees,sierra:Sierra Nevada).}
\item{especie}{Nombre de la especie (lenga: Nothofagus pumilio, frangel: Kageneckia angustifolia,
               uncinata: Pinus uncinata, sylvestris: Pinus sylvestris).}
\item{clase.altitud}{Clase de altitud. "Treeline", intermedia es "inter", y cercana a
      bosque como bajo.}
\item{arbol}{Código del árbol muestra.}
\item{delta.g}{Incremento en área basal (en cm\eqn{^{2}}{^2}) durante los últimos 10 años.}
\item{ipa.g}{Incremento periodico anual en área basal (en cm\eqn{^{2}}{^2}/año), durante los últimos 10 años.}
 }
}
\source{
Los datos fueron obtenidos desde el repisotorio DRYAD en \doi{10.5061/dryad.ks97h}.
}
\usage{
data(baiTreelines2)
}
\description{
Este set de datps contiene 157 observaciones, de los ultimos 10 años en 6-8 árboles adultos de cuatro especies 
en un gradiente altitudinal. Las muestras se distribuyeron en cuatro localidades o sitios de Chile y dos en Espanha.
}
\examples{
data(baiTreelines2)    
head(baiTreelines2) 
with(baiTreelines2, tapply(ipa.g, list("Altitud"=clase.altitud, "Clima"=clima), mean))
}
\references{
Piper F, Vinegla B, Linares J, Camarero J, Cavieres L, Fajardo A. 2016. Mediterranean and temperate treelines are 
controlled by different environmental drivers. Journal Ecology. 104: 691-702.
}
\keyword{datasets}
