% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{pspLlancahue2}
\alias{pspLlancahue2}
\title{Ubicacion espacial de arboles dentro de una parcela de muestreo en el bosque de Llancahue, Valdivia, Chile.}
\format{
Contiene las siguientes variables a nivel de arbol
\describe{
\item{arbol}{Codigo identificador del arbol.}
\item{especie}{Abreviacion de la especie: AP= Aextocicon puncatatum, EC=Eucryphia cordifolia, GA=Gevuina avellana, 
 LP= Laureliopsis philippiana, LS= Laurelia sempervirens, ND=Nothofagus dombeyi, Ot=Other, PS=Podocarpus saligna}
\item{dap}{Diametro a la altura del pecho, en cm.}
\item{coord.x}{Posicion cartesiana en el eje-X, en m.}
\item{coord.y}{Posicion cartesiana en el eje-Y, en m.}
\item{especie.ori}{Abreviacion original para las especies.}
 }
}
\source{
Los datos fueron cedidos por el Prof. Daniel Soto de la Universidad de Aysen (Coyhaique, Chile).
}
\usage{
data(pspLlancahue2)
}
\description{
Posicion cartesiana, especie, y diametro de arboles dentro de una parcela rectangular de 130 m por 70 m.
}
\examples{
data(pspLlancahue2)    
head(pspLlancahue2) 
tapply(pspLlancahue2$dap,pspLlancahue2$especie,length) 
boxplot(dap~especie, data=pspLlancahue2)
}
\references{
- Soto DP, Salas C, Donoso PJ, Uteau D. 2010. Heterogeneidad estructural y espacial de un bosque mixto dominado por
Nothofagus dombeyi despues de un disturbio parcial. Revista Chilena de Historia Natural 83(3): 335-347.
}
\keyword{datasets}
