% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-file.R
\name{import-file}
\alias{import-file}
\alias{import_file_ui}
\alias{import_file_server}
\title{Import data from a file}
\usage{
import_file_ui(
  id,
  title = TRUE,
  preview_data = TRUE,
  file_extensions = c(".csv", ".txt", ".xls", ".xlsx", ".rds", ".fst", ".sas7bdat",
    ".sav")
)

import_file_server(
  id,
  btn_show_data = TRUE,
  show_data_in = c("popup", "modal"),
  trigger_return = c("button", "change"),
  return_class = c("data.frame", "data.table", "tbl_df", "raw"),
  reset = reactive(NULL),
  read_fns = list()
)
}
\arguments{
\item{id}{Module's ID.}

\item{title}{Module's title, if \code{TRUE} use the default title,
use \code{NULL} for no title or a \code{shiny.tag} for a custom one.}

\item{preview_data}{Show or not a preview of the data under the file input.}

\item{file_extensions}{File extensions accepted by \code{\link[shiny:fileInput]{shiny::fileInput()}}, can also be MIME type.}

\item{btn_show_data}{Display or not a button to display data in a modal window if import is successful.}

\item{show_data_in}{Where to display data: in a \code{"popup"} or in a \code{"modal"} window.}

\item{trigger_return}{When to update selected data:
\code{"button"} (when user click on button) or
\code{"change"} (each time user select a dataset in the list).}

\item{return_class}{Class of returned data: \code{data.frame}, \code{data.table}, \code{tbl_df} (tibble) or \code{raw}.}

\item{reset}{A \code{reactive} function that when triggered resets the data.}

\item{read_fns}{Named list with custom function(s) to read data:
\itemize{
\item the name must be the extension of the files to which the function will be applied
\item the value must be a function that can have 5 arguments (you can ignore some of them, but you have to use the same names),
passed by user through the interface:
\itemize{
\item \code{file}: path to the file
\item \code{sheet}: for Excel files, sheet to read
\item \code{skip}: number of row to skip
\item \code{dec}: decimal separator
\item \code{encoding}: file encoding
\item \code{na.strings}: character(s) to interpret as missing values.
}
}}
}
\value{
\itemize{
\item UI: HTML tags that can be included in shiny's UI
\item Server: a \code{list} with three slots:
\itemize{
\item \strong{status}: a \code{reactive} function returning the status: \code{NULL}, \code{error} or \code{success}.
\item \strong{name}: a \code{reactive} function returning the name of the imported data as \code{character}.
\item \strong{data}: a \code{reactive} function returning the imported \code{data.frame}.
}
}
}
\description{
Let user upload a file and import data
}
\examples{


library(shiny)
library(datamods)

ui <- fluidPage(
  tags$h3("Import data from a file"),
  fluidRow(
    column(
      width = 4,
      import_file_ui(
        id = "myid",
        file_extensions = c(".csv", ".txt", ".xls", ".xlsx", ".json")
      )
    ),
    column(
      width = 8,
      tags$b("Import status:"),
      verbatimTextOutput(outputId = "status"),
      tags$b("Name:"),
      verbatimTextOutput(outputId = "name"),
      tags$b("Data:"),
      verbatimTextOutput(outputId = "data")
    )
  )
)

server <- function(input, output, session) {

  imported <- import_file_server(
    id = "myid",
    # Custom functions to read data
    read_fns = list(
      xls = function(file, sheet, skip, encoding) {
        readxl::read_xls(path = file, sheet = sheet, skip = skip)
      },
      json = function(file) {
        jsonlite::read_json(file, simplifyVector = TRUE)
      }
    ),
    show_data_in = "modal"
  )

  output$status <- renderPrint({
    imported$status()
  })
  output$name <- renderPrint({
    imported$name()
  })
  output$data <- renderPrint({
    imported$data()
  })

}

if (interactive())
  shinyApp(ui, server)
}
