% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{update_legend}
\alias{update_legend}
\title{Dynamically update legend}
\usage{
update_legend(proxy)
}
\arguments{
\item{proxy}{a proxy as returned by \code{\link{datamapsProxy}}.}
}
\description{
Dynamically update legend using Shiny
}
\examples{
\dontrun{
library(shiny)

ui <- fluidPage(
  actionButton(
    "show",
    "Show legend"
  ),
  datamapsOutput("map")
)

server <- function(input, output){
  states <- data.frame(st = c("AR", "NY", "CA", "IL", "CO", "MT", "TX"),
                       val = c(10, 5, 3, 8, 6, 7, 2))

  output$map <- renderDatamaps({
    states \%>\%
      datamaps(scope = "usa", default = "lightgray") \%>\%
      add_choropleth(st, val)
  })

  observeEvent(input$update, {
    datamapsProxy("map") \%>\%
      update_legend() # update
  })
}

shinyApp(ui, server)
}

}
