% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddo_ddf.R
\name{ddf}
\alias{ddf}
\title{Instantiate a Distributed Data Frame ('ddf')}
\usage{
ddf(conn, transFn = NULL, update = FALSE, reset = FALSE, control = NULL,
  verbose = TRUE)
}
\arguments{
\item{conn}{an object pointing to where data is or will be stored for the 'ddf' object - can be a 'kvConnection' object created from \code{\link{localDiskConn}} or \code{\link{hdfsConn}}, or a data frame or list of key-value pairs}

\item{transFn}{transFn a function to be applied to the key-value pairs of this data prior to doing any processing, that transform the data into a data frame if it is not stored as such}

\item{update}{should the attributes of this object be updated?  See \code{\link{updateAttributes}} for more details.}

\item{reset}{should all persistent metadata about this object be removed and the object created from scratch?  This setting does not effect data stored in the connection location.}

\item{control}{parameters specifying how the backend should handle things if attributes are updated (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}

\item{verbose}{logical - print messages about what is being done}
}
\description{
Instantiate a distributed data frame ('ddf')
}
\examples{
# in-memory ddf
d <- ddf(iris)
d

# local disk ddf
conn <- localDiskConn(tempfile(), autoYes = TRUE)
addData(conn, list(list("1", iris[1:10,])))
addData(conn, list(list("2", iris[11:110,])))
addData(conn, list(list("3", iris[111:150,])))
dl <- ddf(conn)
dl

# hdfs ddf (requires RHIPE / Hadoop)
\dontrun{
  # connect to empty HDFS directory
  conn <- hdfsConn("/tmp/irisSplit")
  # add some data
  addData(conn, list(list("1", iris[1:10,])))
  addData(conn, list(list("2", iris[11:110,])))
  addData(conn, list(list("3", iris[111:150,])))
  # represent it as a distributed data frame
  hdd <- ddf(conn)
}
}

