% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typing.R
\name{enforce_types}
\alias{enforce_types}
\title{Enforced typing in R
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
\usage{
enforce_types(level = c("error", "warn", "none"))
}
\arguments{
\item{level}{Should type failures error, warn, or be skipped (none)?}
}
\description{
This function allows for simple type enforcement in R inspired by C++ and
other compiled languages. There are currently six primitive types which the
function handles:
}
\details{
\itemize{
\item \code{int()}: An integer specified with the \emph{L} syntax (i.e., `1L``)
\item \code{chr()}: A string or character
\item \code{lgl()}: A boolean TRUE/FALSE
\item \code{dbl()}: A double or numeric value
\item \code{tbl()}: A data frame or tibble (types within the data frame are not checked)
}

You can also provide default arguments within the parenthesis of the type. This
is shown in the example below. You can provide new arguments as well. The function
has knowledge of the function declaration when it runs. Note: types are checked
at runtime not when the function is declared.
}
\examples{
foo <- function(
  x = int(1L),
  y = chr("Hello!"),
  z = lgl(TRUE),
  a = dbl(1.1),
  b = tbl(mtcars),
  c = NULL # This argument will not be checked
) {

  # Simply place enforce_types() in your function header!
  dataclass::enforce_types()

  # Function logic ...
}

# This run the function with the type defaults
foo()

# This will check types but for new arguments
foo(2L, "Hi!", FALSE, 1.2, mtcars)

# This would fail because types are incorrect!
# foo(1.1, FALSE, NULL, "Hi", list())

# This function will only warn when there are type failures
bar <- function(x = int(1)) {
  dataclass::enforce_types("warn")
}
}
