% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{chr_vec}
\alias{chr_vec}
\title{Validator: Check if element is a character}
\usage{
chr_vec(
  max_len = Inf,
  min_len = 1,
  allowed = NA,
  level = "error",
  allow_na = FALSE,
  allow_dups = TRUE
)
}
\arguments{
\item{max_len}{The maximum length of a character element}

\item{min_len}{The minimum length of a character element}

\item{allowed}{A vector of allowable values}

\item{level}{Setting "warn" throws a warning, setting "error" halts}

\item{allow_na}{Should NA values be allowed?}

\item{allow_dups}{Should duplicates be allowed?}
}
\value{
A function with the following properties:
\itemize{
\item Checks whether something is a character vector
\item Determines whether the check will throw warning or error
\item Optionally checks for element length
\item Optionally checks for allowable values
}
}
\description{
This function is used to check whether something is a character. You can use
this function to check the length and allowable values of character. You can
also specify the level of a violation. If level is set to "warn" then invalid
inputs will warn you. However, if level is set to "error" then invalid inputs
will abort.
}
\examples{
# Define a dataclass for testing characters:
my_dataclass <-
  dataclass(
    string = chr_vec(allowed = c("this", "or", "that")),
    other_string = chr_vec()
  )

# `string` must be one of these: `c("this", "or", "that")`
my_dataclass(
  string = "this",
  other_string = "I can be anything I want (as long as I am a string)"
)
}
