% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_session_csv.R
\name{download_session_csv}
\alias{download_session_csv}
\title{Download Session Spreadsheet As CSV}
\usage{
download_session_csv(
  vol_id = 1,
  file_name = "test.csv",
  target_dir = tempdir(),
  as_df = FALSE,
  vb = FALSE,
  rq = NULL
)
}
\arguments{
\item{vol_id}{An integer. Target volume number. Default is 1.}

\item{file_name}{A character string. Name for the output file.
Default is 'test.csv'.}

\item{target_dir}{A character string. Directory to save downloaded file.
Default is \code{tempdir()}.}

\item{as_df}{A logical value. Convert the data from a list to a data frame.
Default is FALSE.}

\item{vb}{A logical value. Provide verbose feedback. Default is FALSE.}

\item{rq}{An \code{httr2} request object. Default is NULL.}
}
\value{
A character string that is the name of the downloaded file or a data frame if \code{as_df} is TRUE.
}
\description{
Databrary generates a CSV-formated spreadsheet that summarizes
information about individual sessions. This command downloads that CSV file
as a temporary file or with a name specified by the user.
}
\examples{
\donttest{
\dontrun{
download_session_csv() # Downloads "session" CSV for volume 1
}
}

}
