% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatWQPdata.R, R/whatWQPsites.R
\name{whatWQPsamples}
\alias{whatWQPsamples}
\alias{whatWQPmetrics}
\alias{whatWQPsites}
\title{Site Data Import from Water Quality Portal}
\usage{
whatWQPsamples(..., convertType = TRUE, legacy = TRUE)

whatWQPmetrics(..., convertType = TRUE)

whatWQPsites(..., legacy = TRUE)
}
\arguments{
\item{\dots}{see \url{https://www.waterqualitydata.us/webservices_documentation}
for a complete list of options. A list of arguments can also be supplied.
One way to figure out how to construct a WQP query is to go to the "Advanced" 
form in the Water Quality Portal:
\url{https://www.waterqualitydata.us/#mimeType=csv&providers=NWIS&providers=STORET}
Use the form to discover what parameters are available. Once the query is 
set in the form, scroll down to the "Query URL". You will see the parameters
after "https://www.waterqualitydata.us/#". For example, if you chose "Nutrient"
in the Characteristic Group dropdown, you will see characteristicType=Nutrient
in the Query URL. The corresponding argument for dataRetrieval is
characteristicType = "Nutrient". dataRetrieval users do not need to include
mimeType,  and providers is optional (these arguments are picked automatically).}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE},
the function will convert the data to dates, datetimes,
numerics based on a standard algorithm. If false, everything is returned as a character.}

\item{legacy}{Logical. If TRUE, uses legacy WQP services. Default is TRUE.
Setting legacy = FALSE uses WQX3.0 WQP services, which are in-development, use with caution.}
}
\value{
data frame
}
\description{
Returns a list of sites from the Water Quality Portal web service. This function
gets the data from: \url{https://www.waterqualitydata.us}.
Arguments to the function should be based on
\url{https://www.waterqualitydata.us/webservices_documentation}. The return from
this function returns the basic metadata on WQP sites. It is
generally faster than the \code{\link{whatWQPdata}} function, but does
not return information on what data was collected at the site.
}
\details{
The \code{readWQPsummary} function has
}
\examples{
\donttest{

site1 <- whatWQPsamples(siteid = "USGS-01594440")

type <- "Stream"

sites <- whatWQPsamples(countycode = "US:55:025", siteType = type)

lakeSites_samples <- whatWQPsamples(siteType = "Lake, Reservoir, Impoundment",
                                    countycode = "US:55:025")
}
\donttest{

type <- "Stream"

sites <- whatWQPmetrics(countycode = "US:55:025", siteType = type)
lakeSites_metrics <- whatWQPmetrics(siteType = "Lake, Reservoir, Impoundment",
                                    countycode = "US:55:025")
}
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

site1 <- whatWQPsites(siteid = "USGS-01594440")

type <- "Stream"
sites <- whatWQPsites(
  countycode = "US:55:025",
  characteristicName = "Phosphorus",
  siteType = type
)
}
\dontshow{\}) # examplesIf}
}
\seealso{
whatWQPdata readWQPsummary

whatNWISdata
}
\keyword{WQP}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}
