% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getWQPSites}
\alias{getWQPSites}
\alias{whatWQPsites}
\title{Site Data Import from Water Quality Portal}
\usage{
getWQPSites(...)

whatWQPsites(...)
}
\arguments{
\item{\dots}{see \url{www.waterqualitydata.us/webservices_documentation.jsp} for a complete list of options}
}
\value{
retval dataframe with first column dateTime, and at least one qualifier and value columns
(subsequent qualifier/value columns could follow depending on requested parameter codes)
}
\description{
Returns a list of sites from the Water Quality Portal web service. This function gets the data from: \url{http://www.waterqualitydata.us}.
Arguments to the function should be based on \url{www.waterqualitydata.us/webservices_documentation.jsp}
}
\examples{
\dontrun{
site1 <- whatWQPsites(siteid="USGS-01594440")

type <- "Stream"
sites <- whatWQPsites(statecode="US:55",countycode="US:55:025",siteType=type)
}
}
\keyword{WQP}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

