% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dict.R
\name{build_dict}
\alias{build_dict}
\title{Build a data dictionary for a dataset.}
\usage{
build_dict(my.data, linker, option_description = NULL,
  prompt_varopts = TRUE)
}
\arguments{
\item{my.data}{Data.frame. The data set for which the user is creating the 
dictionary for.}

\item{linker}{Data.frame. A data frame that has the variable names from the 
original dataset, and also a avriable type that will tell the dictionary whether 
to list unique item options or a range of values for each variable name.}

\item{option_description}{A vector that has the description of each variable 
option in the order in which these appear and depending on how the variable type 
was set while building the linker data frame. If using the prompt_varopts option, 
this value must be NULL.}

\item{prompt_varopts}{Logical. Whether to add the option_description manually 
as prompted by R. Default is set to TRUE. If FALSE, an option_description vector 
must be provided.}
}
\value{
A data frame that will serve as a data dictionary for an original dataset. 
The user will have the option to add this dictionary as an attribute to the original 
dataset with the other package functions.
}
\description{
\code{build_dict} constructs a data dictionary for a dataset with the aid of 
a data linker. This is the second function used in this package. For the function 
to run, the following parameters are needed.
}
\examples{
# example original data set for which a dictionary will be made
data("esoph")
my.data <- esoph

# Linker: Add description for each variable names and variable type
variable_description <- c("age group in years", "alcohol consumption in gm/day", 
"tobacco consumption in gm/day", "number of cases (showing a range)", 
"number of controls (showing range)")

variable_type <- c(0, 0, 0, 0, 0)
linker <- build_linker(my.data = my.data, variable_description = variable_description, 
variable_type = variable_type)
linker

# Data dictionary
# For this data set, no further option description is needed.
dictionary <- build_dict(my.data = my.data, linker = linker, option_description = NULL, 
prompt_varopts = FALSE)
dictionary

}
