% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setVisuals.R
\name{setVisuals}
\alias{setVisuals}
\title{Set visual arguments for makeDataReport}
\usage{
setVisuals(character = NULL, factor = NULL, labelled = NULL,
  haven_labelled = NULL, numeric = NULL, integer = NULL, logical = NULL,
  Date = NULL, all = "standardVisual")
}
\arguments{
\item{character}{A function name (character string) to be used as the visual function for character
variables. If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{factor}{A function name (character string) to be used as the visual function for factor
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{labelled}{A function name (character string) to be used as the visual function for labelled
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{haven_labelled}{A function name (character string) to be used as the visual function for haven_labelled
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{numeric}{A function name (character string) to be used as the visual function for numeric
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{integer}{A function name (character string) to be used as the visual function for integer
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{logical}{A function name (character string) to be used as the visual function for logical
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{Date}{A function name (character string) to be used as the visual function for Date
variables.  If \code{NULL} (the default) the argument is ignored and the contents of the \code{all}
argument is used instead.}

\item{all}{A function name (character string) to be used as the visual function for all
variables.}
}
\value{
A list with one entry for each data class supported by \code{makeDataReport}. Each
entry then contains a character string with a function name that is to be called as the visual 
function for that variable type.
}
\description{
This function is a tool for easily specifying the \code{visuals} argument of 
\code{\link{makeDataReport}}. Note that only a single visual function can 
be provided for each variable type. If more than one is supplied, only 
the first one is used. The default is to use a single visual function for all 
variable types (as specified in the argument \code{all}), but class-specific choices
of visual functions can also be used. Note that class-specific arguments overwrites 
the contents of \code{all}. Note that all available visual function options can be inspected
by calling \code{allVisualFunctions()}.
}
\examples{
#Set visual type to basicVisual for all variable types:
  setVisuals(all = "basicVisual")
     
#Used in a call to makeDataReport():
\dontrun{
data(toyData)
makeDataReport(toyData, visuals = setVisuals(all = "basicVisual"), replace = TRUE)
}
          
}
\seealso{
\code{\link{makeDataReport}}, \code{\link{allVisualFunctions}}
}
