% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\alias{query.qry_sql}
\alias{query.qry_sparql}
\title{Execute a query on data.world.}
\usage{
query(qry, ...)

\method{query}{qry_sql}(qry, ...)

\method{query}{qry_sparql}(qry, ...)
}
\arguments{
\item{qry}{Query object of type qry_sql or qry_sparql.}

\item{...}{S3 method specific params.}
}
\value{
Query results as a data frame.
}
\description{
Execute a query on data.world.
}
\section{Methods (by class)}{
\itemize{
\item \code{qry_sql}: Execute a SQL query on data.world.

\item \code{qry_sparql}: Execute a SPARQL query on data.world.
}}

\examples{
\dontrun{
  sql_stmt <- data.world::qry_sql("SELECT * FROM Tables")
  query_results_df <- data.world::query(
    sql_stmt, "jonloyens/an-intro-to-dataworld-dataset")
}
\dontrun{
  sparql_stmt <- data.world::qry_sparql("SELECT ?s ?p ?o
                                         WHERE {
                                           ?s ?p ?o.
                                         }")
  query_results_df <- data.world::query(
    sparql_stmt, "jonloyens/an-intro-to-dataworld-dataset")
}
}
\seealso{
\code{\link{sql}} \code{\link{sparql}}
}
