% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{save_report}
\alias{save_report}
\title{Saving results as a HTML report}
\usage{
save_report(
  report,
  output_file = "validation_report.html",
  output_dir = getwd(),
  ui_constructor = render_semantic_report_ui,
  template = system.file("rmarkdown/templates/standard/skeleton/skeleton.Rmd", package =
    "data.validator"),
  ...
)
}
\arguments{
\item{report}{Report object that stores validation results.}

\item{output_file}{Html file name to write report to.}

\item{output_dir}{Target report directory.}

\item{ui_constructor}{Function of \code{validation_results} and optional parameters that
generates HTML code or HTML widget that should be used to generate report content. See
\code{custom_report} example.}

\item{template}{Path to Rmd template in which ui_constructor is rendered. See
\code{data.validator} rmarkdown template to see basic construction - the one is used as a
default template.}

\item{...}{Additional parameters passed to \code{ui_constructor}.}
}
\description{
Saving results as a HTML report
}
