% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.hamming.r
\name{gl.filter.hamming}
\alias{gl.filter.hamming}
\title{Filters loci in a genlight object based on pairwise Hamming distance between sequence tags}
\usage{
gl.filter.hamming(gl = gl, t = 0.2, rs = 5, probar = TRUE)
}
\arguments{
\item{gl}{-- genlight object [required]}

\item{t}{-- a threshold Hamming distance for filtering loci [default 0.2]}

\item{rs}{-- number of bases in the restriction enzyme recognition sequence [default = 4]}

\item{probar}{-- switch to output progress bar [default is false]}
}
\value{
a genlight object filtered on Hamming distance.
}
\description{
Hamming distance is calculated as the number of base differences between two 
sequences which can be expressed as a count or a proportion. Typically, it is
calculated between two sequences of equal length. In the context of DArT
trimmed sequences, which differ in length but which are anchored to the left
by the restriction enzyme recognition sequence, it is sensible to compare the
two trimmed sequences starting from immediately after the common recognition
sequence and terminating at the last base of the shorter sequence.
}
\details{
Hamming distance can be computed 
by exploiting the fact that the dot product of two binary vectors x and (1-y)
counts the corresponding elements that are different between x and y.
This approach can also be used for vectors that contain more than two possible 
values at each position (e.g. A, C, T or G).

If a pair of DNA sequences are of differing length, the longer is truncated.

The algorithm is that of Johann de Jong 
\url{https://johanndejong.wordpress.com/2015/10/02/faster-hamming-distance-in-r-2/}
as implimented in utils.hamming.r

Only one of two loci are retained if their Hamming distance is less that a specified
percentage. 5 base differences out of 100 bases is a 20% Hamming distance.
}
\examples{
gl <- gl.filter.hamming(testset.gl, t=0.25)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
