% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.set.wd.r
\name{gl.set.wd}
\alias{gl.set.wd}
\title{Sets the default working directory}
\usage{
gl.set.wd(wd = tempdir(), verbose = NULL)
}
\arguments{
\item{wd}{Set the path to the wd directory globally to be used by all functions if not set explicitely in the function.}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
path the the working directory [set for all functions]
}
\description{
Many dartR functions have a plot.dir parameter which is used to save output to (e.g. ggplots as rds files)
 With this functions users can set the working directory globally so it is used in all functions, without setting is explicitely. 
 The value for wd is stored in the r environment and if not set defaults to tempdir(). This script sets the default value.
}
\examples{
#set to current working directory
wd <- gl.set.wd(wd=getwd())

}
\seealso{
Other environment: 
\code{\link{gl.check.verbosity}()},
\code{\link{gl.check.wd}()},
\code{\link{gl.print.history}()},
\code{\link{theme_dartR}()}
}
\author{
Custodian: Bernd Gruber (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{environment}
