% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2treemix.r
\name{gl2treemix}
\alias{gl2treemix}
\title{Converts a genlight object to a treemix input file}
\usage{
gl2treemix(x, outfile = "treemix_input.gz", outpath = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{outfile}{File name of the output file (including gz extension)
[default 'treemix_input.gz'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report

[default 2 or as specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
The output file contains the SNP data in the format expected by treemix --
see the treemix manual. The file will be gzipped before in order to be
recognised by treemix. Plotting functions provided with treemix will need to
 be sourced from the treemix download page.
}
\examples{
gl2treemix(testset.gl, outpath=tempdir())

}
\references{
Pickrell and Pritchard (2012). Inference of population splits and
mixtures from genome-wide allele frequency data. PLoS Genetics
 https://doi.org/10.1371/journal.pgen.1002967
}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2fasta}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Arthur Georges (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
