% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{dann.recipe}
\alias{dann.recipe}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
\method{dann}{recipe}(
  x,
  data,
  k = 5,
  neighborhood_size = max(floor(nrow(data)/5), 50),
  epsilon = 1,
  ...
)
}
\arguments{
\item{x}{A recipe from recipes library.}

\item{data}{A data frame.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{...}{Additional parameters passed to methods.}
}
\value{
An S3 class of type dann.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
This is an implementation of Hastie and Tibshirani's
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest Neighbor Classification publication.}.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)
library(recipes)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

rec_obj <- recipe(Y ~ X1 + X2, data = train)

dann(rec_obj, train)
}
