% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dal_norm_zscore.R
\name{zscore}
\alias{zscore}
\title{z-score normalization}
\usage{
zscore(nmean = 0, nsd = 1)
}
\arguments{
\item{nmean}{new mean for normalized data}

\item{nsd}{new standard deviation for normalized data}
}
\value{
z-score transformation object
}
\description{
Scale data using z-score normalization.
\eqn{zscore = (x - \mu)/\sigma},
where \eqn{\mu} is the mean of \eqn{x}
and \eqn{\sigma} is the standard deviation.
}
\examples{
data(iris)
head(iris)

trans <- zscore()
trans <- fit(trans, iris)
tiris <- transform(trans, iris)
head(tiris)

itiris <- inverse_transform(trans, tiris)
head(itiris)
}
