% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001_effsize_func.R
\name{effect_size}
\alias{effect_size}
\alias{mean_diff}
\alias{median_diff}
\alias{cohens_d}
\alias{hedges_g}
\alias{cliffs_delta}
\alias{cohens_h}
\title{Calculating effect sizes}
\usage{
mean_diff(dabest_obj, perm_count = 5000)

median_diff(dabest_obj, perm_count = 5000)

cohens_d(dabest_obj, perm_count = 5000)

hedges_g(dabest_obj, perm_count = 5000)

cliffs_delta(dabest_obj, perm_count = 5000)

cohens_h(dabest_obj, perm_count = 5000)
}
\arguments{
\item{dabest_obj}{A dabest_obj created by loading in dataset along with other
specified parameters with the \code{\link[=load]{load()}} function.}

\item{perm_count}{The number of reshuffles of control and test labels to be performed for each p-value.}
}
\value{
Returns a \code{dabest_effectsize_obj} list with 22 elements. The following are the elements contained within:
\itemize{
\item \code{raw_data} The tidy dataset passed to \code{\link[=load]{load()}} that was cleaned and altered for plotting.
\item \code{idx} The list of control-test groupings as initially passed to \code{\link[=load]{load()}}.
\item \code{delta_x_labels} Vector containing labels for the x-axis of the delta plot.
\item \code{delta_y_labels} String label for the y-axis of the delta plot.
\item \code{Ns} List of labels for x-axis of the raw plot.
\item \code{raw_y_labels} Vector containing labels for the y-axis of the raw plot.
\item \code{is_paired} Boolean value determining if it is a paired plot.
\item \code{is_colour} Boolean value determining if there is a colour column for the plot.
\item \code{paired} Paired ("sequential" or "baseline") as initially passed to \code{\link[=load]{load()}}.
\item \code{resamples} The number of resamples to be used to generate the effect size bootstraps.
\item \code{control_summary} Numeric value for plotting of control summary lines for float_contrast = \code{TRUE}.
\item \code{test_summary} Numeric value for plotting of control summary lines for float_contrast = \code{TRUE}.
\item \code{ylim} Vector containing the y limits for the raw plot.
\item \code{enquo_x} Quosure of x as initially passed to \code{\link[=load]{load()}}.
\item \code{enquo_y} Quosure of y as initially passed to \code{\link[=load]{load()}}.
\item \code{enquo_id_col} Quosure of id_col as initially passed to \code{\link[=load]{load()}}.
\item \code{enquo_colour} Quosure of colour as initially passed to \code{\link[=load]{load()}}.
\item \code{proportional} Boolean value as initially passed to \code{\link[=load]{load()}}.
\item \code{minimeta} Boolean value as initially passed to \code{\link[=load]{load()}}.
\item \code{delta} Boolean value as initially passed to \code{\link[=load]{load()}}.
\item \code{proportional_data} List of calculations related to the plotting of proportion plots.
\item \code{boot_result} List containing values related to the calculation of the effect sizes,
bootstrapping and BCa correction.
\item \code{baseline_ec_boot_result} List containing values related to the calculation
of the effect sizes, bootstrapping and BCa correction for the baseline error
curve.
\item \code{permtest_pvals} List containing values related to the calculations of permutation
t tests and the corresponding p values, and p values for different types of effect sizes
and different statistical tests.
}
}
\description{
Computes the effect size for each control-test group pairing in \code{idx}.
The resampling bootstrap distribution of the effect size is then subjected
to Bias-corrected and accelerated bootstrap (BCa) correction.

The following effect sizes \code{mean_diff}, \code{median_diff}, \code{cohens_d}, \code{hedges_g} and \code{cliffs_delta}
are used for most plot types.
}
\details{
The plot types listed under here are limited to use only the following effect sizes.
\itemize{
\item Proportion plots offers only \code{mean_diff} and \code{cohens_h}.
\item Mini-Meta Delta plots offers only \code{mean_diff}.
}

The other plots are able to use all given basic effect sizes as listed in the Description.
}
\examples{
# Loading of the dataset
data(non_proportional_data)

# Applying effect size to the dabest object
dabest_obj <- load(non_proportional_data,
  x = Group, y = Measurement,
  idx = c("Control 1", "Test 1")
)
dabest_obj.mean_diff <- mean_diff(dabest_obj)

# Printing dabest effectsize object
print(dabest_obj.mean_diff)
}
