% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{component_shelf}
\alias{component_shelf}
\title{Diffusion Model Components}
\usage{
component_shelf()
}
\value{
A list of the respective functions; each entry/function can be accessed by
"name" (see the Example and Details).
}
\description{
This function is meant as a convenient way to access pre-built
model component functions.
}
\details{
The function provides the following functions:
\itemize{
\item \code{mu_constant}, provides the component function for a constant
drift rate with parameter \code{muc}.
\item \code{mu_dmc}, provides the drift rate of the superimposed diffusion process
of DMC. Necessary parameters are \code{muc} (drift rate of the controlled
process), \code{a} (shape..), \code{A} (amplitude...), \code{tau} (scale of the
automatic process).
\item \code{mu_ssp}, provides the drift rate for SSP.
Necessary parameters are \code{p} (perceptual input of flankers and
target), \code{sd_0} (initial spotlight width), \code{r} (shrinking rate of the
spotlight) and 'sign' (an auxiliary parameter for controlling the
contribution of the flanker stimuli). Note that no \code{mu_int_ssp} exists.
\item \code{mu_int_constant}, provides the complementary integral to \code{mu_constant}.
\item \code{mu_int_dmc}, provides the complementary integral to \code{mu_dmc}.
\item \code{x_dirac_0}, provides a dirac delta for a starting point
centered between the boundaries (no parameter required).
\item \code{x_uniform}, provides a uniform distribution for a start point
centered between the boundaries. Requires a parameter \code{range_start}
(between 0 and 2).
\item \code{x_beta}, provides the function component for a symmetric
beta-shaped starting point distribution with parameter \code{alpha}.
\item \code{b_constant}, provides a constant
boundary with parameter \code{b}.
\item \code{b_hyperbol}, provides a collapsing boundary in terms of a
hyperbolic ratio function with parameters
\code{b0} as the initial value of the (upper) boundary,
\code{kappa} the size of the collapse, and \code{t05} the point in time where
the boundary has collapsed by half.
\item \code{b_weibull}, provides a collapsing boundary in terms of a
Weibull distribution with parameters
\code{b0} as the initial value of the (upper) boundary,
\code{lambda} controlling the time of the collapse,
\code{k} the shape of the collapse, and \code{kappa} the size of the collapse.
\item \code{dt_b_constant}, the first derivative of \code{b_constant}.
\item \code{dt_b_hyperbol}, the first derivative of \code{b_hyperbol}.
\item \code{nt_constant}, provides a constant
non-decision time with parameter \code{non_dec}.
\item \code{nt_uniform}, provides a uniform distribution for the
non-decision time. Requires the parameters \code{non_dec} and \code{range_non_dec}.
\item \code{nt_truncated_normal}, provides the component function for
a normally distributed non-decision time with parameters \code{non_dec},
\code{sd_non_dec}. The Distribution is truncated to \eqn{[0, t_{max}]}.
\item \code{dummy_t} a function that accepts all required arguments for \code{mu_fun} or
\code{mu_int_fun} but which throws an error. Might come in handy when a user
doesn't require the integral of the drift rate.
}

See \code{vignette("customize_ddms", "dRiftDM")} for more information on how
to set/modify/customize the components of a diffusion model.
}
\examples{
pre_built_functions <- component_shelf()
names(pre_built_functions)

}
