% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.quantification_and_export.R
\name{export_csv}
\alias{export_csv}
\title{Export dPCP analysis results to a csv file}
\usage{
export_csv(data, filename)
}
\arguments{
\item{data}{an object of class \code{dPCP}, \code{target_quant} or
\code{replicates_quant}.}

\item{filename}{character. File name (no extension) for csv and pdf files to
create on disk.}
}
\value{
A csv file with the information and results of dPCP analysis.
}
\description{
This function exports dPCP analysis results to a csv file.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata",package = "dPCP")

#dPCP analysis
results <- dPCP(sampleTable, system = "bio-rad", file.location = fileLoc,
                eps = 200, minPts = 50, save.template = FALSE,
                rain = TRUE)

export_csv(results, filename = "dPCRproject_1")
}
}
