% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.quantification_and_export.R
\name{report_dPCP}
\alias{report_dPCP}
\title{Export dPCP analysis results to a pdf report}
\usage{
report_dPCP(data, filename, sample = "all")
}
\arguments{
\item{data}{an object of class \code{dPCP}, inherited from
\code{\link{dPCP}}.}

\item{filename}{character. File name (no extension) for csv and pdf files to
create on disk.}

\item{sample}{'all' to show all samples, or a numeric vector indicating
the row number of samples in the sample table.}
}
\value{
A pdf file with the information and results of the dPCP analysis.
}
\description{
This function generates a pdf report of the dPCP analysis.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

#dPCP analysis
results <- dPCP(sampleTable, system = "bio-rad", file.location = fileLoc,
                eps = 200, minPts = 50, save.template = FALSE,
                rain = TRUE)

report_dPCP(results, filename = "dPCRproject_1")
}
}
