% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph.R
\name{d3_igraph}
\alias{d3_igraph}
\title{Convert 'igraph' to 'd3.js'}
\usage{
d3_igraph(igrf = NULL, json = TRUE)
}
\arguments{
\item{igrf}{\code{igraph}}

\item{json}{\code{logical} to return as \code{JSON}}
}
\value{
\code{list}
}
\description{
Convert 'igraph' to 'd3.js'
}
\examples{
\dontrun{
library(igraph)
library(igraphdata)
library(d3r)

# with random graph
d3r::d3_igraph(igraph::sample_pa(100))

# check case where vertices 0 cols
d3_igraph(igraph::watts.strogatz.game(1, 50, 4, 0.05))

# with karate from igraphdata
#  notice graph attributes are added
data("karate",package="igraphdata")
(karate_d3 <- d3r::d3_igraph(karate))

listviewer::jsonedit(karate_d3)

data("kite",package="igraphdata")
listviewer::jsonedit(d3_igraph(kite))
}
}
