% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journey.R
\name{smooth_with_cutoffs}
\alias{smooth_with_cutoffs}
\title{Identify and smooth-out anomalous gradient values}
\usage{
smooth_with_cutoffs(
  gradient_segment,
  elevation_change,
  distances,
  distance_cutoff = 50,
  gradient_cutoff = 0.1,
  n = 3
)
}
\arguments{
\item{gradient_segment}{The gradient for each segment from CycleStreets.net}

\item{elevation_change}{The difference between the maximum and minimum elevations within each segment}

\item{distances}{The distance of each segment}

\item{distance_cutoff}{Distance (m) used to identify anomalous gradients}

\item{gradient_cutoff}{Gradient (\%, e.g. 0.1 being 10\%) used to identify anomalous gradients}

\item{n}{The number of segments to use to smooth anomalous gradents.
The default is 3, meaning segments directly before, after and including the offending segment.}
}
\description{
When \code{distance_cutoff} and \code{gradient_cutoff} thresholds are both broken
for route segments, this function treats them as anomalous and
sets the offending gradient values to the mean of the \code{n}
segments closest to (in front of and behind) the offending segment.
}
\examples{
f = system.file(package = "cyclestreets", "extdata/journey.json")
obj = jsonlite::read_json(f, simplifyVector = TRUE)
rsf = json2sf_cs(obj, cols = c("distances"))
rsf$gradient_segment
rsf$elevation_change
rsf$distances
smooth_with_cutoffs(rsf$gradient_segment, rsf$elevation_change, rsf$distances)
smooth_with_cutoffs(rsf$gradient_segment, rsf$elevation_change, rsf$distances, 20, 0.05)
smooth_with_cutoffs(rsf$gradient_segment, rsf$elevation_change, rsf$distances, 200, 0.02)
smooth_with_cutoffs(rsf$gradient_segment, rsf$elevation_change, rsf$distances, 200, 0.02, n = 5)
}
