% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxr_er_bootstrap.R
\name{cxr_er_bootstrap}
\alias{cxr_er_bootstrap}
\title{standard error estimates for effect and response parameters}
\usage{
cxr_er_bootstrap(
  fitness_model,
  optimization_method,
  data,
  covariates,
  init_par,
  lower_bounds,
  upper_bounds,
  fixed_parameters,
  bootstrap_samples
)
}
\arguments{
\item{fitness_model}{effect/response function, see \code{cxr_er_fit}}

\item{optimization_method}{numerical optimization method.}

\item{data}{either a list of dataframes or a single dataframe. if 'data' is a list, each element is a dataframe with the following columns:
\itemize{
\item fitness: fitness metric for each observation
\item neighbours: named columns giving the number of neighbours of each column
the names of the list elements are taken to be the names of the focal species.
}

If 'data' is a dataframe, it also needs a 'focal' column.
Regardless of the data structure, all focal species need to have the same number of observations (i.e. same number of rows),
and the set of neighbour species needs to be the same as the set of focal species, so that
the neighbours columns correspond to the names of the list elements or, if 'data' is a dataframe,
to the values of the 'focal' column. Future versions will relax this requirement.}

\item{covariates}{a data structure equivalent to 'data', in which each column are the values of a covariate.}

\item{init_par}{initial values for parameters}

\item{lower_bounds}{optional list with single values for "lambda", "effect","response",
and optionally "lambda_cov", "effect_cov", "response_cov".}

\item{upper_bounds}{optional list with single values for "lambda", "effect","response",
and optionally "lambda_cov", "effect_cov", "response_cov".}

\item{fixed_parameters}{list with values for fixed parameters, or NULL.}

\item{bootstrap_samples}{number of bootstrap samples for error calculation. Defaults to 0, i.e. no error is calculated.}
}
\value{
1d vector, the standard error of each parameter in init_par
}
\description{
Computes bootstrap standard errors for a given effect/response function.
This function is provided for completeness, but error calculation is
integrated in the function \code{cxr_er_fit}.
}
