% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CalibrationSet.R
\name{CalibrationSet}
\alias{CalibrationSet}
\alias{CalibrationSet-class}
\alias{caliset}
\title{Calibration set}
\usage{
caliset(scenario, data, weight = 1.0)
}
\arguments{
\item{scenario}{a \link{scenario} describing conditions during the experiment}

\item{data}{a \code{data.frame} with observed data in long format containing two
columns: the 1st column with \code{numeric} time points and 2nd column with
\code{numeric} data to fit to.}

\item{weight}{optional \code{numeric} weight to be applied to this dataset's error
term during fitting, default values is 1.0.}
}
\value{
\code{caliset()} returns a \emph{calibration set} object
}
\description{
A \emph{calibration set} combines a \link{scenario}, observed data, and an
optional weighting factor into one object. The \emph{calibration set} is used to fit
model parameters to observed data using \code{\link[=calibrate]{calibrate()}}.
}
\details{
A \emph{calibration set} usually represents a single experiment or trial.
Multiple experimental replicates can be combined into a single \emph{set}, if model
parameters are identical between trials.
If model parameters were modified during a trial, e.g. a pump failure occurred
or flow rates changed, this can be represented by using a \emph{scenario sequence}
instead of a basic \link{scenario}. Please refer to \code{\link[=sequence]{sequence()}} for details.
\subsection{Weighting}{

If more than one \emph{calibration set} is used for fitting, then an optional
weighting factor can be used to scale the error term of the affected \emph{set}.
}
}
\examples{
library(dplyr)

# Get observed biomass during control experiment by Schmitt et al. (2013)
observed <- Schmitt2013 \%>\%
  filter(ID == "T0") \%>\%
  select(t, BM=obs)

# Create a scenario that represents conditions during experiment
scenario <- metsulfuron \%>\%
  set_param(c(k_phot_fix=TRUE, k_resp=0, Emax=1)) \%>\%
  set_init(c(BM=12)) \%>\%
  set_noexposure()

# Create a calibration set
cs <- caliset(scenario, observed)

# Fit parameter 'k_phot_max' to observed biomass growth from experiment
calibrate(
  cs,
  par=c(k_phot_max=1),
  output="BM",
  method="Brent", # Brent is recommended for one-dimensional optimization
  lower=0,        # lower parameter boundary
  upper=0.5       # upper parameter boundary
) -> fit
fit$par

}
