% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost-functions.R
\name{mse}
\alias{mse}
\alias{costFunctions}
\alias{rmse}
\alias{medAbsErr}
\alias{BayesRule}
\alias{BayesRule2}
\title{Cost Functions for Fitted Regression Models}
\usage{
mse(y, yhat)

rmse(y, yhat)

medAbsErr(y, yhat)

BayesRule(y, yhat)

BayesRule2(y, yhat)
}
\arguments{
\item{y}{response}

\item{yhat}{fitted value}
}
\value{
In general, cost functions should return a single numeric
value measuring lack-of-fit. \code{mse()} returns the mean-squared error;
\code{rmse()} returns the root-mean-squared error;
\code{medAbsErr()} returns the median absolute error;
and BayesRule()\code{and}BayesRule2()` return the proportion of misclassified cases.
}
\description{
Compute cost functions (cross-validation criteria) for fitted
regression models.
}
\details{
Cost functions (cross-validation criteria) are meant to measure lack-of-fit. Several cost functions are provided:
\enumerate{
\item \code{mse()} returns the mean-squared error of prediction for
a numeric response variable \code{y} and predictions \code{yhat}; and
\code{rmse()} returns the root-mean-squared error and is just the
square-root of \code{mse()}.
\item \code{medAbsErr()} returns the median absolute error of prediction for a numeric
response \code{y} and predictions \code{yhat}.
\item \code{BayesRule()} and \code{BayesRule2()} report the proportion
of incorrect predictions for a dichotomous response variable \code{y}, assumed
coded (or coercible to) \code{0} and \code{1}. The \code{yhat} values are
predicted probabilities and are rounded to 0 or 1. The distinction
between \code{BayesRule()} and \code{BayesRule2()} is that the former
checks that the \code{y} values are all either \code{0} or \code{1}
and that the \code{yhat} values are all between 0 and 1, while
the latter doesn't and is therefore faster.
}
}
\section{Functions}{
\itemize{
\item \code{mse()}: Mean-square error

\item \code{rmse()}: Root-mean-square error

\item \code{medAbsErr()}: Median absolute error

\item \code{BayesRule()}: Bayes Rule for a binary response

\item \code{BayesRule2()}: Bayes rule for a binary response (without bounds checking)

}}
\examples{
data("Duncan", package="carData")
m.lm <- lm(prestige ~ income + education, data=Duncan)
mse(Duncan$prestige, fitted(m.lm))

data("Mroz", package="carData")
m.glm <- glm(lfp ~ ., data=Mroz, family=binomial)
BayesRule(Mroz$lfp == "yes", fitted(m.glm))
}
\seealso{
\code{\link{cv}}, \code{\link{cvSelect}}
}
