% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cutpoint}
\alias{cutpoint}
\alias{cutpoints}
\title{Extract the cutpoints from a ROC curve generated by cutpointr}
\usage{
cutpoint(x, ...)

cutpoints(x, ...)
}
\arguments{
\item{x}{A roc_cutpointr object.}

\item{...}{Further arguments.}
}
\description{
This is a utility function for extracting the cutpoints from a \code{roc_cutpointr}
object. Mainly useful in conjunction with the \code{plot_cutpointr} function if
cutpoints are to be plotted on the x-axis.
}
\examples{
oc <- cutpointr(suicide, dsi, suicide, gender)
plot_cutpointr(oc, cutpoint, accuracy)

}
\seealso{
Other metric functions: \code{\link{F1_score}},
  \code{\link{abs_d_ppv_npv}},
  \code{\link{abs_d_sens_spec}}, \code{\link{accuracy}},
  \code{\link{cohens_kappa}},
  \code{\link{false_omission_rate}},
  \code{\link{metric_constrain}},
  \code{\link{misclassification_cost}}, \code{\link{npv}},
  \code{\link{odds_ratio}}, \code{\link{p_chisquared}},
  \code{\link{plr}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{prod_ppv_npv}},
  \code{\link{prod_sens_spec}}, \code{\link{recall}},
  \code{\link{risk_ratio}}, \code{\link{roc01}},
  \code{\link{sensitivity}}, \code{\link{specificity}},
  \code{\link{sum_ppv_npv}}, \code{\link{sum_sens_spec}},
  \code{\link{total_utility}}, \code{\link{tpr}},
  \code{\link{tp}}, \code{\link{youden}}
}
\concept{metric functions}
