% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unfold.R
\name{unfold}
\alias{unfold}
\alias{unfold.spatial_cubble_df}
\alias{unfold.temporal_cubble_df}
\title{Augment spatial component into the long (temporal) form}
\usage{
unfold(data, ...)

\method{unfold}{spatial_cubble_df}(data, ...)

\method{unfold}{temporal_cubble_df}(data, ...)
}
\arguments{
\item{data}{a long cubble object}

\item{...}{spatial variables to move into the long form,
support tidyselect syntax}
}
\value{
a cubble object in the long form
}
\description{
Some spatio-temporal transformation, i.e. glyph maps, uses both spatial
and temporal variables. \code{unfold()} allows you to temporarily moves spatial
variables into the long form for these transformations.
}
\examples{
climate_mel |> face_temporal() |> unfold(long, lat)
climate_mel |> face_temporal() |> unfold(dplyr::starts_with("l"))
}
