% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map-auto.R
\name{plot_map}
\alias{plot_map}
\title{A quick plot of sites on an underlying map}
\usage{
plot_map(map_data, point_data, print_code = FALSE)
}
\arguments{
\item{map_data}{the dataset contains the map object, an sf object}

\item{point_data}{a cubble object to plot the site}

\item{print_code}{whether to print out the ggplot2 code, default to FALSE}
}
\value{
a ggplot object
}
\description{
\code{plot_map} allows you to quickly create a ggplot with your base map
and cubble object, with some default aesthetic and theme settings.
}
\details{
It should generally be used to quickly create some prototype maps. To make
further modification on the map, set \code{print_code = TRUE}. This will print
the code in the console as well as write it into the clipboard (so you can
directly paste it into your script).
}
\examples{
library(ggplot2)
state_map <- rmapshaper::ms_simplify(ozmaps::abs_ste, keep = 2e-3)
# a quick plot
plot_map(state_map, climate_aus)

\dontrun{
# print out the ggplot2 code of the map
plot_map(state_map, climate_aus, print_code = TRUE)
}
}
