% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_msready_by_mass_with_error_batch}
\alias{get_msready_by_mass_with_error_batch}
\title{Get msready by mass and error offset}
\usage{
get_msready_by_mass_with_error_batch(
  masses = NULL,
  error = NULL,
  API_key = NULL,
  rate_limit = 0,
  verbose = FALSE
)
}
\arguments{
\item{masses}{A numeric list of masses.}

\item{error}{The mass offset value.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A list (of lists) of DTXSIDs, with a list returned for each input
mass value.
}
\description{
Get msready by mass and error offset
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
#Pull chemicals by msready mass and error offset
msready_data <- get_msready_by_mass_with_error_batch(masses = c(226, 228),
                                                     error = 4)
\dontshow{\}) # examplesIf}
}
