% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_lists_containing_chemical}
\alias{get_lists_containing_chemical}
\title{Get chemical lists containing given chemical}
\usage{
get_lists_containing_chemical(
  DTXSID = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A list of names of chemical lists that contain the given chemical
}
\description{
Get chemical lists containing given chemical
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical lists containing BPA
bpa_lists <- get_lists_containing_chemical(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
