% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemicals_in_list_contain}
\alias{get_chemicals_in_list_contain}
\title{Get chemicals in a list specified by contained characters}
\usage{
get_chemicals_in_list_contain(
  list_name = NULL,
  word = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{list_name}{The name of the list to search}

\item{word}{The contained characters to match chemicals in the given list}

\item{API_key}{The user-specific api key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A list of DTXSIDs matching the list and search word criteria
}
\description{
Get chemicals in a list specified by contained characters
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bis_biosolids_2021 <- get_chemicals_in_list_contain(list_name = 'BIOSOLIDS2021',
                                                    word = 'Bis')
\dontshow{\}) # examplesIf}
}
