% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ifsct.R
\encoding{UTF-8}
\name{plot_ifsct}
\alias{plot_ifsct}
\title{Constructs the IFS circle transformation of a
categorical time series}
\usage{
plot_ifsct(
  series,
  categories,
  alpha,
  beta,
  title = "IFS circle transformation",
  ...
)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{alpha}{Parameter alpha in the circle transformation.}

\item{beta}{Parameter beta in the circle transformation.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
The IFS circle transformation.
}
\description{
\code{plot_ifsct} constructs the IFS circle transformation of
a categorical time series.
}
\details{
Constructs the IFS circle transformation for a given CTS, which is
useful to identify cycles of arbitrary length.
}
\examples{
ct <- plot_ifsct(GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')),
alpha = 0.1, beta = 0.1) # Constructing the IFS circle transformation
# for the first CTS in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008visual}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
