% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_probabilities.R
\encoding{UTF-8}
\name{marginal_probabilities}
\alias{marginal_probabilities}
\title{Computes the marginal probabilities of a categorical time series}
\usage{
marginal_probabilities(series, categories)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}
}
\value{
A vector with the marginal probabilities.
}
\description{
\code{marginal_probabilities} returns a vector with the marginal
probabilities of a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
vector \eqn{\widehat{\boldsymbol p} =(\widehat{p}_1, \ldots, \widehat{p}_r)},
with \eqn{\widehat{p}_i=\frac{N_i}{T}}, where \eqn{N_i} is the number
of elements equal to \eqn{i} in the realization \eqn{\overline{X}_t}.
}
\examples{
vector_mp <- marginal_probabilities(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the vector of
# marginal probabilities for the first series in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
