% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_isMedIntervTrial.R
\name{f.isMedIntervTrial}
\alias{f.isMedIntervTrial}
\title{Calculate if study is a medicine-interventional study}
\usage{
f.isMedIntervTrial(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with colums `_id` and `.isMedIntervTrial`, a logical.
}
\description{
Trial concept calculated: Calculates if record is a medicine-interventional
trial, investigating one or more medicine, whether biological or not.
For EUCTR and CTIS, this corresponds to all records as per the definition
of the EU Clinical Trial Regulation.
For CTGOV and CTGOV2, this is based on drug or biological as type
of intervention, and interventional as type of study.
For ISRCTN, this is based on drug or biological as type
of intervention, and interventional as type of study.
}
\examples{
# fields needed
f.isMedIntervTrial()

\dontrun{

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.isMedIntervTrial",
  con = dbc)
}

}
