% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrdata-registers.R
\docType{data}
\name{ctrdata-registers}
\alias{ctrdata-registers}
\title{ctrdata: information on clinical trial registers}
\description{
Registers of clinical trials that can be accessed with
package \link{ctrdata-package} as of November 2022.
The EU CTIS will be mandatory for sponsors from January 2023
and cannot yet supported by \code{ctrdata}.
}
\details{
\itemize{
\item \strong{EUCTR}: The European Union Clinical Trials Register contains
almost 43,000 clinical trials (using one or more medicines as
investigational medicinal product, IMP; in Europe and beyond)
\item \strong{CTGOV}: ClinicalTrials.gov includes more than 430,000
interventional and observational studies (the beta website
is not supported by package \code{ctrdata})
\item \strong{ISRCTN}: The ISRCTN Registry includes almost 23,000
interventional or observational health studies
\item \strong{CTIS}: The EU Clinical Trials Information System was
started in January 2023, including around 150 trials March 2023
}\tabular{lcccc}{
   \strong{Material} \tab \strong{EUCTR} \tab \strong{CTGOV} \tab \strong{ISRCTN} \tab \strong{CTIS} \cr
   Home page \tab \href{https://www.clinicaltrialsregister.eu/}{link} \tab \href{https://clinicaltrials.gov/}{link} \tab \href{https://www.isrctn.com/}{link} \tab \href{https://euclinicaltrials.eu/}{link} \cr
   About \tab \href{https://www.clinicaltrialsregister.eu/about.html}{link} \tab \href{https://clinicaltrials.gov/ct2/about-site/background}{link} \tab \href{https://www.isrctn.com/page/about}{link} \tab \href{https://euclinicaltrials.eu/about-this-website/}{link} \cr
   Terms and conditions, disclaimer \tab \href{https://www.clinicaltrialsregister.eu/disclaimer.html}{link} \tab \ifelse{latex}{\out{\href{https://clinicaltrials.gov/ct2/about-site/terms-conditions\#Use}{link}}}{\href{https://clinicaltrials.gov/ct2/about-site/terms-conditions#Use}{link}} \tab \ifelse{latex}{\out{\href{https://www.isrctn.com/page/faqs\#usingISRCTN}{link}}}{\href{https://www.isrctn.com/page/faqs#usingISRCTN}{link}} \tab \href{https://euclinicaltrials.eu/guidance-and-q-as/}{link} \cr
   How to search \tab \href{https://www.clinicaltrialsregister.eu/doc/How_to_Search_EU_CTR.pdf}{link} \tab \href{https://clinicaltrials.gov/ct2/help/how-find/advanced}{link} \tab \href{https://www.isrctn.com/page/search-tips}{link} \tab \href{https://euclinicaltrials.eu/search-tips-and-guidance/}{link} \cr
   Search interface \tab \href{https://www.clinicaltrialsregister.eu/ctr-search/search}{link} \tab \href{https://clinicaltrials.gov/ct2/search/advanced}{link} \tab \href{https://www.isrctn.com/}{link} \tab \href{https://euclinicaltrials.eu/app/#/search}{link} \cr
   Glossary \tab \href{https://www.clinicaltrialsregister.eu/doc/EU_Clinical_Trials_Register_Glossary.pdf}{link} \tab \href{https://clinicaltrials.gov/ct2/about-studies/glossary}{link} \tab \href{https://www.who.int/clinical-trials-registry-platform/network/who-data-set}{link} \tab  \cr
   FAQ \tab \href{https://www.clinicaltrialsregister.eu/doc/EU_CTR_FAQ.pdf}{link} \tab \href{https://clinicaltrials.gov/ct2/resources/pubs}{link} \tab \href{https://www.isrctn.com/page/faqs}{link} \tab  \cr
   Expert / advanced search \tab \href{https://www.clinicaltrialsregister.eu/ctr-search/search}{link} \tab \href{https://clinicaltrials.gov/ct2/results/refine?show_xprt=Y}{link} \tab \href{https://www.isrctn.com/editAdvancedSearch}{link} \tab \href{https://euclinicaltrials.eu/app/#/search}{link} \cr
   Example* \tab \ifelse{latex}{\out{\href{https://www.clinicaltrialsregister.eu/ctr-search/search?query=Infections\&age=newborn\&age=preterm-new-born-infants}{link}}}{\href{https://www.clinicaltrialsregister.eu/ctr-search/search?query=Infections&age=newborn&age=preterm-new-born-infants}{link}} \tab \ifelse{latex}{\out{\href{https://clinicaltrials.gov/ct2/results/refine?term=AREA[MaximumAge]+RANGE[0+days,1+months]\&type=Intr\&cond=Infections\&intr=Investigational+Agent\&show_xprt=Y}{link}}}{\href{https://clinicaltrials.gov/ct2/results/refine?term=AREA\%5BMaximumAge\%5D+RANGE\%5B0+days,1+months\%5D&type=Intr&cond=Infections&intr=Investigational+Agent&show_xprt=Y}{link}} \tab \ifelse{latex}{\out{\href{https://www.isrctn.com/search?q=\&filters=ageRange:Neonate,conditionCategory:Infections+and+Infestations\&searchType=advanced-search}{link}}}{\href{https://www.isrctn.com/search?q=&filters=ageRange:Neonate,conditionCategory:Infections+and+Infestations&searchType=advanced-search}{link}} \tab  \cr
   Definitions \tab \href{https://eudract.ema.europa.eu/result.html}{link} \tab \href{https://prsinfo.clinicaltrials.gov/definitions.html}{Protocol}, \href{https://prsinfo.clinicaltrials.gov/results_definitions.html}{results}, \href{https://clinicaltrials.gov/api/gui/ref/crosswalks}{names}, \href{https://clinicaltrials.gov/api/gui/ref/syntax}{syntax} \tab \href{https://www.isrctn.com/page/definitions}{link} \tab  \cr
}


*The example is an expert search that retrieves interventional
trials with neonates, investigating infectious conditions:
EUCTR retrieves trials with neonates, but not exclusively.
The CTGOV expert search retrieves trials exclusively in neonates.
ISRCTN retrieves a small number of studies.
Thus, after loading trials with \link{ctrLoadQueryIntoDb}
into a database collection, corresponding sets of trials need to be defined,
based on values of fields of interest
(e.g., \code{eligibility.maximum_age} from CTGOV and
\code{f115_children_211years} from EUCTR),
which can be obtained from the collection using \link{dbGetFieldsIntoDf}.
}
\author{
Ralf Herold \email{ralf.herold@mailbox.org}
}
\keyword{data}
