% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ctrGetQueryUrl}
\alias{ctrGetQueryUrl}
\title{Get query details}
\usage{
ctrGetQueryUrl(url = "", register = "")
}
\arguments{
\item{url}{URL such as from the browser address bar.
If not specified, clipboard contents will be checked for
a suitable URL. Can also contain a query term such as from
\link{dbQueryHistory}()["query-term"]}

\item{register}{Optional name of register (i.e., "EUCTR" or
"CTGOV") in case url is a query term}
}
\value{
A data frame (or tibble, if \code{dplyr} is loaded)
with column names `query-term` and `query-register`.
The data frame (or tibble) can be passed as such as parameter
`query-term` to \link{ctrLoadQueryIntoDb} and as parameter
`url` to \link{ctrOpenSearchPagesInBrowser}.
}
\description{
Extracts query parameters and register name from parameter `url` or
from the clipboard, into which the URL of a register search was copied.
}
\examples{

# user copied into the clipboard the URL from
# the address bar of the browser that shows results
# from a query in one of the trial registers
try(ctrGetQueryUrl(), silent = TRUE)

# extract query parameters from search result URL
# (URL was cut for the purpose of formatting only)
ctrGetQueryUrl(
  url = paste0("https://clinicaltrials.gov/ct2/results?",
  "cond=&term=AREA\%5BMaximumAge\%5D+RANGE\%5B0+days\%2C+28+days\%5D",
  "&type=Intr&rslt=&age_v=&gndr=&intr=Drugs\%2C+Investigational",
  "&titles=&outc=&spons=&lead=&id=&cntry=&state=&city=&dist=",
  "&locn=&phase=2&rsub=&strd_s=01\%2F01\%2F2015&strd_e=01\%2F01\%2F2016",
  "&prcd_s=&prcd_e=&sfpd_s=&sfpd_e=&rfpd_s=&rfpd_e=&lupd_s=&lupd_e=&sort="))

}
