% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.R
\name{in_csquares}
\alias{in_csquares}
\title{Match c-squares against other c-squares (with wildcards)}
\usage{
in_csquares(x, table, strict = FALSE, mode = "any", ...)
}
\arguments{
\item{x}{An object of class 'csquares' that will be checked for matching
values in \code{table}}

\item{table}{A \code{character} string representing a csquares code. The
code can contain wildcards (asterisk \code{*} and percentage \verb{\%} characters,
both having identical meaning). Any symbol in \code{x} will result in a positive match
against the wildcard. \code{table} can also be of class \code{csquares}, but these
objects cannot contain wildcards.}

\item{strict}{When set to \code{FALSE}, a match is positive when the start
of \code{x}, matches against values in \code{table}, even when \code{x} has a higher resolution.
When set to \code{TRUE}, a match is only positive when the resolution of \code{x} and
\code{table} is identical.}

\item{mode}{Two modes are allowed: \code{"all"} and \code{"any"}. When an element of
\code{x} consists of multiple raster cells, it the mode will determine whether
a match is positive or not. In case of \code{"all"}, all raster cells in the element
of \code{x} need to match with the cells in \code{table}, for a positive match. In
case of \code{"any"}, any match will do.}

\item{...}{Ignored}
}
\value{
Returns a vector of \code{logical} values with the same number of
elements or rows as \code{x}
}
\description{
Checks if csquares codes in \code{table} matches values in \code{x}. Wildcards
are allowed in \code{table} for this comparison. Check out \code{vignette("wildcards")}
for more details.
}
\examples{
library(dplyr)

in_csquares(orca$csquares, c("3400:2", "5515:3"))
in_csquares(orca$csquares, "3400:2|5515:3")

## Percentage symbols are interpreted the same as asterisk symbols
## both are wild cards
in_csquares(orca$csquares, "1\%\%\%:\%") |>
  table()

## Same as above
in_csquares(orca$csquares, "1***:*") |>
  table()
 
## Also same as above
in_csquares(orca$csquares, "1***", strict = FALSE) |>
  table()

## Strict interpretation results in no matches
in_csquares(orca$csquares, "1***", strict = TRUE) |>
  table()

## Filter orca data to North Eastern quadrant (1***:*) only:
orca |>
  filter(
    in_csquares(csquares, "1***:*")
  ) |>
  nrow()

}
\author{
Pepijn de Vries
}
