% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_panel.R
\name{plot_panel}
\alias{plot_panel}
\title{Generate time series plots of CSPP data}
\usage{
plot_panel(
  cspp_data = NULL,
  var_name = NULL,
  years = NULL,
  colors = c("#b3a4a4", "#8f3838", "#dbdbdb")
)
}
\arguments{
\item{cspp_data}{Dataframe generated by \code{get_cspp_data} which must
include the variable \code{st.abb}.}

\item{var_name}{Specific variable within the dataframe passed to `cspp_data`
to plot. If left NULL, will automatically plot the first variable after
state identifiers.}

\item{years}{Specify years within the passed dataframe to plot. If left NULL,
will plot all years for which not all observations have missing values.
Takes a vector of years.}

\item{colors}{Specify the colors to be used in a grid plot. Must include
three values in a character vector format. The default values are
`c("#b3a4a4", "#8f3838", "#dbdbdb")`. If the variable plotted is
dichotomous, the first color is the non-treated value and the second color
is the treated value. The third color is the value for NA. If plotting a
continuous variable, the first color is the low end of the gradient and the
second value is the high end of the gradient. See
\code{\link[ggplot2]{scale_fill_gradient}}.}
}
\value{
ggplot2 object
}
\description{
\code{plot_panel} takes CSPP data from \code{\link{get_cspp_data}} and plots
the values of the passed variable name in a time series (grid or line)
format.
}
\details{
This function will take any dataframe consisting of the variables `year` and
`st.abb` plus one other variable.
}
\examples{

# dichotomous variable
cspp <- get_cspp_data(vars = c("drugs_medical_marijuana"))
plot_panel(cspp)

# change colors and years
plot_panel(cspp, colors = c("white", "blue", "black"),
                 years = seq(1980, 2000))

# continuous variable with missing data:
continuous_data <- get_cspp_data(vars = c("h_diffs"))

plot_panel(continuous_data, colors = c("white", "dodgerblue", "#eeeeee"))

# add ggplot2 features
library(ggplot2)
plot_panel(continuous_data, colors = c("white", "dodgerblue", "#eeeeee")) +
  theme(legend.position = "none") +
  ggplot2::ggtitle("Continuous variable")
}
\seealso{
\code{\link{get_var_info}}, \code{\link{get_cites}}, \code{\link{generate_map}}
}
