/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.ShapefileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountryDistancer {
    private int year;
    private int month;
    private int day;
    private int dimension;
    private double[] ctrcodes;
    private double tolerance;
    private String ctrcode;
    private String syear;
    private String smonth;
    private String sday;
    private String eyear;
    private String emonth;
    private String eday;
    private String packageHome;

    public CountryDistancer(String packageHome, int year, int month, int day, double tolerance, boolean useGW) {
        this.packageHome = packageHome;
        this.year = year;
        this.month = month;
        this.day = day;
        this.tolerance = tolerance;
        if (!useGW) {
            this.ctrcode = "COWCODE";
            this.syear = "COWSYEAR";
            this.smonth = "COWSMONTH";
            this.sday = "COWSDAY";
            this.eyear = "COWEYEAR";
            this.emonth = "COWEMONTH";
            this.eday = "COWEDAY";
        } else {
            this.ctrcode = "GWCODE";
            this.syear = "GWSYEAR";
            this.smonth = "GWSMONTH";
            this.sday = "GWSDAY";
            this.eyear = "GWEYEAR";
            this.emonth = "GWEMONTH";
            this.eday = "GWEDAY";
        }
    }

    private ArrayList<Feature> getRelevantFeatures() {
        FeatureCollection fc = null;
        try {
            File file = new File(this.packageHome, "shp/cshapes.shp");
            DriverProperties dp = new DriverProperties(file.getAbsolutePath());
            fc = new ShapefileReader().read(dp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Feature> flist = new ArrayList<Feature>();
        Iterator it = fc.iterator();
        GregorianCalendar atdate = new GregorianCalendar(this.year, this.month, this.day);
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            int startyear = ((Number)f.getAttribute(this.syear)).intValue();
            int startmonth = ((Number)f.getAttribute(this.smonth)).intValue();
            int startday = ((Number)f.getAttribute(this.sday)).intValue();
            int endyear = ((Number)f.getAttribute(this.eyear)).intValue();
            int endmonth = ((Number)f.getAttribute(this.emonth)).intValue();
            int endday = ((Number)f.getAttribute(this.eday)).intValue();
            GregorianCalendar startdate = new GregorianCalendar(startyear, startmonth, startday);
            GregorianCalendar enddate = new GregorianCalendar(endyear, endmonth, endday);
            if (startdate.compareTo(atdate) > 0 || enddate.compareTo(atdate) < 0) continue;
            f.setGeometry(TopologyPreservingSimplifier.simplify(f.getGeometry(), this.tolerance));
            flist.add(f);
        }
        Collections.sort(flist, new Comparator<Feature>(){

            @Override
            public int compare(Feature o1, Feature o2) {
                Integer cow1 = (Integer)o1.getAttribute(CountryDistancer.this.ctrcode);
                Integer cow2 = (Integer)o2.getAttribute(CountryDistancer.this.ctrcode);
                return cow1.compareTo(cow2);
            }
        });
        this.ctrcodes = new double[flist.size()];
        for (int i = 0; i < flist.size(); ++i) {
            Feature feature = (Feature)flist.get(i);
            Integer code = (Integer)feature.getAttribute(this.ctrcode);
            this.ctrcodes[i] = code.intValue();
        }
        this.dimension = flist.size();
        return flist;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double[] getCtrcodes() {
        return this.ctrcodes;
    }

    public double[] getMinDistMatrix() {
        ArrayList<Feature> flist = this.getRelevantFeatures();
        Matrix result = new Matrix(flist.size(), flist.size());
        int total = flist.size() * (flist.size() - 1) / 2;
        int counter = 0;
        for (int i = 0; i < flist.size() - 1; ++i) {
            Feature f1 = flist.get(i);
            for (int j = i + 1; j < flist.size(); ++j) {
                Feature f2 = flist.get(j);
                double dist = this.distanceFeatures(f1, f2);
                result.set(i, j, dist);
                result.set(j, i, dist);
                ++counter;
            }
        }
        return result.getColumnPackedCopy();
    }

    public double[] getCentroidDistMatrix() {
        ArrayList<Feature> flist = this.getRelevantFeatures();
        Matrix result = new Matrix(flist.size(), flist.size());
        int total = flist.size() * (flist.size() - 1) / 2;
        int counter = 0;
        for (int i = 0; i < flist.size() - 1; ++i) {
            Coordinate cent1 = flist.get(i).getGeometry().getCentroid().getCoordinate();
            for (int j = i + 1; j < flist.size(); ++j) {
                Coordinate cent2 = flist.get(j).getGeometry().getCentroid().getCoordinate();
                double dist = this.distanceCoordinates(cent1, cent2);
                result.set(i, j, dist);
                result.set(j, i, dist);
                ++counter;
            }
        }
        return result.getColumnPackedCopy();
    }

    public double[] getCapDistMatrix() {
        ArrayList<Feature> flist = this.getRelevantFeatures();
        Matrix result = new Matrix(flist.size(), flist.size());
        int total = flist.size() * (flist.size() - 1) / 2;
        int counter = 0;
        for (int i = 0; i < flist.size() - 1; ++i) {
            double caplong1 = (Double)flist.get(i).getAttribute("CAPLONG");
            double caplat1 = (Double)flist.get(i).getAttribute("CAPLAT");
            Coordinate cap1 = new Coordinate(caplong1, caplat1);
            for (int j = i + 1; j < flist.size(); ++j) {
                double caplong2 = (Double)flist.get(j).getAttribute("CAPLONG");
                double caplat2 = (Double)flist.get(j).getAttribute("CAPLAT");
                Coordinate cap2 = new Coordinate(caplong2, caplat2);
                double dist = this.distanceCoordinates(cap1, cap2);
                result.set(i, j, dist);
                result.set(j, i, dist);
                ++counter;
            }
        }
        return result.getColumnPackedCopy();
    }

    private double distanceFeatures(Feature f1, Feature f2) {
        Coordinate[] coords1 = f1.getGeometry().getCoordinates();
        Coordinate[] coords2 = f2.getGeometry().getCoordinates();
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < coords1.length; ++i) {
            Coordinate c1 = coords1[i];
            for (int j = 0; j < coords2.length; ++j) {
                Coordinate c2 = coords2[j];
                double dist = this.distanceCoordinates(c1, c2);
                if (dist <= 0.0) {
                    return 0.0;
                }
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
        }
        return minDist;
    }

    private double distanceCoordinates(Coordinate c1, Coordinate c2) {
        double fromLon = Math.toRadians(c1.x);
        double fromLat = Math.toRadians(c1.y);
        double toLon = Math.toRadians(c2.x);
        double toLat = Math.toRadians(c2.y);
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((fromLat - toLat) / 2.0), 2.0) + Math.cos(fromLat) * Math.cos(toLat) * Math.pow(Math.sin((fromLon - toLon) / 2.0), 2.0)));
        return d * 6378.137;
    }

    public static void main(String[] args) {
        CountryDistancer cd = new CountryDistancer("/Users/nilsw/R/mylibraries/cshapes/inst", 2008, 1, 1, 0.2, false);
        double[] m = cd.getMinDistMatrix();
    }

    public class MessageFrame
    extends JFrame {
        JLabel label;

        MessageFrame() {
            super("cshapes Progress Monitor");
            this.label = new JLabel();
            this.add(this.label);
            this.setSize(300, 100);
            this.setVisible(true);
        }

        public void updateLabel(int completed, int total) {
            this.label.setText("Completed " + completed + " of " + total + " country pairs.");
            this.label.repaint();
        }
    }
}

