% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_macd.R
\name{macd}
\alias{macd}
\title{Add MACD indicators to the chart}
\usage{
macd(
  nFast = 12,
  nSlow = 26,
  nSig = 9,
  maType = "SMA",
  percent = TRUE,
  internal = list(),
  ...
)
}
\arguments{
\item{nFast}{Number of periods for fast moving average.}

\item{nSlow}{Number of periods for slow moving average.}

\item{nSig}{Number of periods for signal moving average.}

\item{maType}{Either:
\enumerate{
  \item A function or a string naming the function to be called.
  \item A \emph{list} with the first component like (1) above, and
    additional parameters specified as \emph{named} components.
    See Examples.
}}

\item{percent}{logical; if \code{TRUE}, the percentage difference between the
fast and slow moving averages is returned, otherwise the difference between
the respective averages is returned.}

\item{internal}{An empty \link{list}. Used for internal purposes. Ignore.}

\item{...}{Other arguments to be passed to the \code{maType} function in
case (1) above.}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Traders and investors use the MACD indicator to identify trend changes, potential reversals, and overbought or oversold conditions in the market.
It is a versatile tool that can be applied to various timeframes and asset classes, making it a valuable part of technical analysis for many traders.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

## charting the klines
## with indicators as
## subcharts
chart(
  ticker     = BTC,
  main       = kline(),
  sub        = list(
    volume(),
    macd()
  ),
  indicator = list(
    bollinger_bands(),
    sma(),
    alma()
  ),
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

## charting the MACD-indicator
## with klines as subcharts
chart(
  ticker     = BTC,
  main       = macd(),
  sub        = list(
    volume(),
    kline()
  ),
  indicator = list(
    bollinger_bands(),
    sma()
  ),
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other subcharts: 
\code{\link{add_event}()},
\code{\link{fgi}()},
\code{\link{lsr}()},
\code{\link{rsi}()},
\code{\link{volume}()}
}
\concept{chart indicators}
\concept{subcharts}
