% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{full_symm_strings}
\alias{full_symm_strings}
\title{Symmetry operations in human readable form}
\usage{
full_symm_strings(SG)
}
\arguments{
\item{SG}{A character string. The extended Hermann-Mauguin symbol (e.g. 'P 1 1 21')}
}
\value{
Symm_string A character vector whose components are strings starting by 'SYMM'
 and containing the symmetry operations of the given group in human-readable form.
}
\description{
This function returns the full set of symmetry operations in human-readable form,
each one as a character string starting with 'SYMM'. These are the common crystallographic
symmetry operations.
}
\examples{
# P1 has only one symmetry operation
SG <- "P 1"
symm_string <- full_symm_strings(SG)
print(symm_string)

# P 21 21 21 is has many more operations
SG <- "P 21 21 21"
symm_string <- full_symm_strings(SG)
print(symm_string)

}
